import { getTableMetaRequest, getTableSpecificationsRequest, getItemsRequest, fetchNewItem } from '@/support/tableApiRequestWithParamsHelpers'
import { fetchAmazonRestock, fetchAmazonRestocks } from '@/services/AmazonIntegrationRestockReportService'

export const IntegrationAmazonInstanceRestockReportModule = {
  namespaced: true,
  state: () => ({
    // table
    itemsList: [],
    tableSpecifications: {},
    maxPages: 0,
    meta: {},
    loading: false,
    instanceId: null,
    // item
    selectedItem: null,
    loadingItem: false,
    drawer: {
      show: false,
      hideNavigator: false,
      initialItemId: false,
      mode: null // view
    }
  }),
  getters: {
    // table
    getItemsList: state => state.itemsList,
    getTableSpecifications: state => state.tableSpecifications,
    getMaxPages: state => state.maxPages,
    getMeta: state => state.meta,
    getLoading: state => state.loading,
    getInstanceId: state => state.instanceId,
    getRequestParams: state => ({ instanceId: state.instanceId }),
    // item
    getSelectedItem: state => state.selectedItem,
    isLoadingItem: state => state.loadingItem,
    getDrawerMode: state => state.drawer.mode,
    getDrawerShow: state => state.drawer.show,
    getDrawerHideNavigator: state => state.drawer.hideNavigator
  },
  mutations: {
    SET_ITEMS_LIST (state, value) {
      state.itemsList = value
    },
    SET_TABLE_SPECIFICATIONS (state, value) {
      state.tableSpecifications = value
    },
    SET_MAX_PAGES (state, value) {
      state.maxPages = value
    },
    SET_META (state, value) {
      state.meta = value
    },
    SET_LOADING (state, value) {
      state.loading = value
    },
    SET_INSTANCE_ID (state, value) {
      state.instanceId = value
    },
    SET_SELECTED_ITEM (state, value) {
      state.selectedItem = value
    },
    SET_LOADING_ITEM (state, value) {
      state.loadingItem = value
    }
  },
  actions: {
    async getItemsRequest ({ commit, getters }, query) {
      return getItemsRequest(query, commit, fetchAmazonRestocks, getters.getRequestParams)
    },
    async getMetaRequest ({ commit, getters }, query) {
      return getTableMetaRequest(query, commit, fetchAmazonRestocks, getters.getRequestParams)
    },
    async loadTableSpecifications ({ commit, getters }, query) {
      return getTableSpecificationsRequest(query, commit, fetchAmazonRestocks, getters.getRequestParams)
    },
    async fetchNewItem ({ commit }, params) {
      return fetchNewItem(commit, fetchAmazonRestock, params)
    }
  }
}
