import { fetchAmazonOrders } from '@/services/AmazonIntegrationOrdersService'

export const IntegrationAmazonInstancePendingOrdersModule = {
  namespaced: true,
  state: () => ({
    itemsList: [],
    tableSpecifications: {},
    maxPages: 0,
    meta: {},
    loading: false,
    instanceId: null,
  }),
  getters: {
    getItemsList: state => state.itemsList,
    getTableSpecifications: state => state.tableSpecifications,
    getMaxPages: state => state.maxPages,
    getMeta: state => state.meta,
    getLoading: state => state.loading,
    getInstanceId: state => state.instanceId,
  },
  mutations: {
    SET_ITEMS_LIST (state, value) {
      state.itemsList = value
    },
    SET_TABLE_SPECIFICATIONS (state, value) {
      state.tableSpecifications = value
    },
    SET_MAX_PAGES (state, value) {
      state.maxPages = value
    },
    SET_META (state, value) {
      state.meta = value
    },
    SET_LOADING (state, value) {
      state.loading = value
    },
    SET_INSTANCE_ID (state, value) {
      state.instanceId = value
    },
  },
  actions: {
    async getItemsRequest ({ commit, getters }, query) {
      if (!getters?.getInstanceId) return
      let params = {...query}
      try {
        commit('SET_LOADING', true)
        const {data,table_specifications} = await fetchAmazonOrders(getters.getInstanceId, params)
        commit('SET_ITEMS_LIST', data)
        if (table_specifications) commit('SET_TABLE_SPECIFICATIONS', table_specifications)
      } catch (e) {
        return Promise.reject(e)
      } finally {
        commit('SET_LOADING', false)
      }
    },
    async getMetaRequest ({ commit, getters }, query) {
      if (!getters?.getInstanceId) return
      try {
        const {meta} = await fetchAmazonOrders(getters.getInstanceId, query)
        if (meta?.last_page) commit('SET_MAX_PAGES', meta.last_page)
        if (meta) commit('SET_META', meta)
      } catch (e) {
        return Promise.reject(e)
      }
    },
    async loadTableSpecifications ({ commit, getters }, query) {
      if (!getters?.getInstanceId) return
      try {
        const {table_specifications} = await fetchAmazonOrders(getters.getInstanceId, query)
        if (table_specifications) commit('SET_TABLE_SPECIFICATIONS', table_specifications)
        return Promise.resolve()
      } catch (e) {
        return Promise.reject(e)
      }
    },
  }
}
