import { getXeroTaxRates, getAccounts } from '@/services/XeroServices'
import { fetchTaxRatesForMapping } from '@/services/TaxRatesService'
import { getTableMetaRequest, getTableSpecificationsRequest, getItemsRequest } from '@/support/tableApiRequestHelpers'

export const XeroModule = {
  namespaced: true,
  state: {
    itemsList: [],
    tableSpecifications: {},
    maxPages: 0,
    meta: {},
    loading: false,
    taxRates: [],
    taxRatesMappings: [],
  },
  getters: {
    getItemsList: state => state.itemsList,
    getTableSpecifications: state => state.tableSpecifications,
    getMaxPages: state => state.maxPages,
    getMeta: state => state.meta,
    getLoading: state => state.loading,
    getSomethingChanged: (state, getters) => {
      return false
    },
    getXeroTaxRates: state => state.taxRates,
    getXerotaxRatesMappingsData: state => state.taxRatesMappings,
    getXeroTaxRatesMappings: state => state.taxRatesMappings.map(tax => {
      tax.valueChanged = false
      tax.complexName = `${tax.name} (${tax.rate}%)`
      return tax
    })
  },
  mutations: {
    SET_ITEMS_LIST (state, value) {
      state.itemsList = value
    },
    SET_TABLE_SPECIFICATIONS (state, value) {
      state.tableSpecifications = value
    },
    SET_MAX_PAGES (state, value) {
      state.maxPages = value
    },
    SET_META (state, value) {
      state.meta = value
    },
    SET_LOADING (state, value) {
      state.loading = value
    },
    SET_XERO_TAX_RATES (state, value = []) {
      state.taxRates = value
    },
    SET_XERO_TAX_RATES_MAPPINGS (state, value = []) {
      state.taxRatesMappings = value.sort((a,b) => a.id > b.id ? 1 : -1)
    }
  },
  actions: {
    async getItemsRequest ({ commit }, query) {
      return getItemsRequest(query, commit, getAccounts)
    },
    async getMetaRequest ({ commit }, query) {
      return getTableMetaRequest(query, commit, getAccounts)
    },
    async loadTableSpecifications ({ commit }, query) {
      return getTableSpecificationsRequest(query, commit, getAccounts)
    },
    async fetchXeroTaxRates ({ commit }) {
      try {
        const {data} = await getXeroTaxRates()
        commit('SET_XERO_TAX_RATES', data)
        return Promise.resolve()
      } catch (e) {
        throw e
      }
    },
    async fetchXeroTaxRatesMappings ({ commit }) {
      try {
        const {data} = await fetchTaxRatesForMapping()
        commit('SET_XERO_TAX_RATES_MAPPINGS', data)
        return Promise.resolve()
      } catch (e) {
        throw e
      }
    }
  }
}
