import Vue from 'vue'
import { isEqual } from 'lodash'
import { getAuthUser } from '@/services/AuthService'
import { updateUserProfile, updateUserPassword } from '@/services/UserProfileService'

export const UsersModule = {
  namespaced: true,
  state: {
    accessToken: 'eyJ0eXAiOiJKV1QiLCJhbGciOiJIUzI1NiJ9.eyJpc3MiOiJodHRwczpcL1wvc2t1LmlvLmFwcFwvYXBpXC9hdXRoXC9sb2dpbiIsImlhdCI6MTU5Mjc0NDI4MCwiZXhwIjoxNTkyNzQ3ODgwLCJuYmYiOjE1OTI3NDQyODAsImp0aSI6IjhqZmU3M1dJeXdKNzVEOUYiLCJzdWIiOjEsInBydiI6ImY2YjcxNTQ5ZGI4YzJjNDJiNzU4MjdhYTQ0ZjAyYjdlZTUyOWQyNGQifQ.BPg2hooeyWG_EH8AwUkFYjkjyx_BBD8HQ1Paalb9ObI',
    fetchingToken: false,
    authUser: {
      id: null,
      name: null,
      email: null,
      is_admin: null,
      is_power_user: null,
      created_at: null
    },
    editedUser: {
      id: null,
      name: null,
      email: null,
      is_admin: null,
      is_power_user: null,
      created_at: null
    },
    errors: {
      old_password: null,
      password_confirmation: null,
      password: null,
      email: null,
      name: null,
      userProfileFields: null
    }
  },
  getters: {
    getAccessToken: state => state.accessToken,
    getFetchingToken: state => state.fetchingToken,
    getAuthUser: state => state.authUser,
    getEditedUser: state => state.editedUser,
    getErrors: state => state.errors,
    getUserChanged: state => !isEqual(state.editedUser, state.authUser) && state.errors.userProfileFields === null,
    getIsAdmin: state => state.authUser.is_admin,
    getIsPowerUser: state => state.authUser.is_power_user,
  },
  mutations: {
    SET_ACCESS_TOKEN (state, token) {
      state.accessToken = token
    },
    SET_FETCHING_TOKEN (state, value) {
      state.fetchingToken = value
    },
    SET_AUTH_USER (state, user) {
      state.authUser = user
    },
    SET_EDITED_USER (state, value) {
      state.editedUser = JSON.parse(JSON.stringify(value))
    },
    SET_EDITED_USER_FIELD (state, { field, value }) {
      Vue.prototype.$set(state.editedUser, field, value)
    },
    SET_ERRORS (state, { field, value }) {
      Vue.prototype.$set(state.errors, field, value)
    },
    SET_CLEAR_ERRORS (state) {
      Object.keys(state.errors).forEach(key => {
        Vue.prototype.$set(state.errors, key, null)
      })
    }
  },
  actions: {
    setAccessToken ({ commit }, token) {
      commit('SET_ACCESS_TOKEN', token)
    },
    setFetchingToken ({ commit }, value) {
      commit('SET_FETCHING_TOKEN', value)
    },
    async requestAuthUser ({ commit, getters }) {
      const response = await getAuthUser()
      if (response && response.hasOwnProperty('data')) {
        commit('SET_AUTH_USER', response.data)
        commit('SET_EDITED_USER', getters.getAuthUser)
      }
    },
    async updateUserProfile ({ commit, dispatch }, payload) {
      try {
        const { status, data } = await updateUserProfile(payload)
        return { status: status, data }
      } catch ({ response }) {
        dispatch('getErrorMessages', response.data.errors)
        return { status: response.status, data: { message: response.data.message } }
      }
    },
    async updateUserPassword ({ commit, dispatch }, payload) {
      try {
        const { status, data } = await updateUserPassword(payload)
        return { status: status, data }
      } catch ({ response }) {
        dispatch('getErrorMessages', response.data.errors)
        return { status: response.status, message: response.data.message }
      }
    },
    getErrorMessages ({ commit }, errors) {
      Object.keys(errors).forEach(key => {
        const messages = errors[key].reduce((acc, err) => {
          acc.push(err.message)
          return acc
        }, [])
        commit('SET_ERRORS', { field: key, value: messages })
      })
    }
  }
}
