import { getTrackedJobLogs } from '@/services/TrackedJobLogsService'

export const TrackedJobLogsModule = {
  namespaced: true,
  state: {
    loading: false,
    itemsList: [],
    tableSpecifications: {},
    maxPages: 0,
    meta: {},
  },
  getters: {
    getLoading: state => state.loading,
    getItemsList: state => state.itemsList,
    getTableSpecifications: state => state.tableSpecifications,
    getMaxPages: state => state.maxPages,
    getMeta: state => state.meta,
  },
  mutations: {
    SET_JOB_LOGS (state, value) {
      state.logs = value
    },
    SET_ITEMS_LOADING (state, value) {
      state.loading = value
    },
    SET_ITEMS_LIST (state, items) {
      state.itemsList = JSON.parse(JSON.stringify(items))
    },
    SET_TABLE_SPECIFICATIONS (state, specs) {
      state.tableSpecifications = specs
    },
    SET_MAX_PAGES (state, pages) {
      state.maxPages = pages
    },
    SET_META (state, meta) {
      state.meta = meta
    },
  },
  actions: {
    async getItemsRequest ({ commit, state }, query) {
      try {
        commit('SET_ITEMS_LOADING', true)
        const response = await getTrackedJobLogs(query)

        if (response?.data) commit('SET_ITEMS_LIST', response.data)
        if (response?.table_specifications) commit('SET_TABLE_SPECIFICATIONS', response.table_specifications)
      } catch (e) {
        throw e
      } finally {
        commit('SET_ITEMS_LOADING', false)
      }
    },
    async getMetaRequest ({ commit }, query) {
      try {
        const response = await getTrackedJobLogs(query)
        if (response?.meta?.last_page) commit('SET_MAX_PAGES', response.meta.last_page)
        if (response?.meta) commit('SET_META', response.meta)
      } catch (e) {
        throw e
      }
    },
    async loadTableSpecifications ({ commit }, query) {
      try {
        const response = await getTrackedJobLogs(query)

        if (response?.data?.table_specifications) commit('SET_TABLE_SPECIFICATIONS', response.data.table_specifications)
        return Promise.resolve()
      } catch (e) {
        throw e
      }
    },
  }
}
