import Vue from 'vue'

export const TaskStatusModule = {
  namespaced: true,
  state: {
    selectedItem: null,
    taskStatusDrawer: {
      initialItemId: null,
      show: false
    }
  },
  getters: {
    getSelectedItem: state => state.selectedItem,
    getTaskStatusDrawer: state => state.taskStatusDrawer
  },
  mutations: {
    SET_SERVER_TASKS_DRAWER_FIELD (state, { value, field }) {
      Vue.prototype.$set(state.taskStatusDrawer, field, value)
    },
    SET_SELECTED_ITEM (state, value) {
      state.selectedItem = value
    }
  }
}
