import { getAllSupplierPricingTiers } from '@/services/SupplierPricingTiersService'
import { getSupplierPricingTiers } from '@/services/SuppliersServices'
import { addComplexName } from '@/support/pricingTierHelpers'

export const SupplierPricingTiers = {
  namespaced: true,
  state: {
    itemsList: [],
    tableSpecifications: {},
    maxPages: 0,
    meta: {},
    loading: false,
    supplierPricingTiers: [],
  },
  getters: {
    getItemsList: state => addComplexName(state.itemsList),
    getTableSpecifications: state => state.tableSpecifications,
    getMaxPages: state => state.maxPages,
    getMeta: state => state.meta,
    getLoading: state => state.loading,
    getDefaultSupplierPricingTier: (state, getters) => {
      return getters.getItemsList.find(i => i.is_default === true) || null
    },
    getSupplierPricingTiers: state => addComplexName(state.supplierPricingTiers),
  },
  mutations: {
    SET_ITEMS_LIST (state, value) {
      state.itemsList = value
    },
    SET_TABLE_SPECIFICATIONS (state, value) {
      state.tableSpecifications = value
    },
    SET_MAX_PAGES (state, value) {
      state.maxPages = value
    },
    SET_META (state, value) {
      state.meta = value
    },
    SET_LOADING (state, value) {
      state.loading = value
    },
    SET_SUPPLIER_PRICING_TIERS (state, value) {
      state.supplierPricingTiers = value
    },
  },
  actions: {
    async getItemsRequest ({ commit }, query) {
      try {
        commit('SET_LOADING', true)
        const response = await getAllSupplierPricingTiers(query)
        commit('SET_ITEMS_LIST', response.data)

        if (response.table_specifications) commit('SET_TABLE_SPECIFICATIONS', response.table_specifications)
      } catch (e) {
        throw e
      } finally {
        commit('SET_LOADING', false)
      }
    },
    async getMetaRequest ({ commit }, query) {
      try {
        const response = await getAllSupplierPricingTiers(query)
        if (response.meta && response.meta.last_page) commit('SET_MAX_PAGES', response.meta.last_page)
        if (response.meta) commit('SET_META', response.meta)
      } catch (e) {
        throw e
      }
    },
    async loadTableSpecifications ({ commit }, query) {
      try {
        const response = await getAllSupplierPricingTiers(query)

        if (response.data?.table_specifications) commit('SET_TABLE_SPECIFICATIONS', response.data.table_specifications)
        return Promise.resolve()
      } catch (e) {
        throw e
      }
    },
    async fetchSupplierPricingTiers ({ commit }, id) {
      try {
        const {data} = await getSupplierPricingTiers(id)
        commit('SET_SUPPLIER_PRICING_TIERS',data)
      } catch (e) {
        throw e
      }
    }, 
  }
}
