import { getAllStores } from '@/services/StoresService'
import { isEqual } from 'lodash'
import Vue from 'vue'

export const StoresModule = {
  namespaced: true,
  state: {
    itemsList: [],
    loading: false,
    tableSpecifications: {},
    maxPages: 0,
    meta: {},
    selectedStore: {},
    updateStoreLoading: false,
    editedStore: {},
    nonAddressFields: [
      'name',
      'email',
      'po_email',
      'logo_url',
      'custom_message',
      'custom_jrxml_file'
    ],
    addressFields: [
      'company_name',
      'phone',
      'fax',
      'address1',
      'address2',
      'address3',
      'city',
      'zip',
      'province',
      'province_code',
      'country',
      'country_code'
    ],
    previewImage: '',
    formIsValid: true,
    brandByIdLoading: false,
    storeDrawer: {
      show: false,
      hideNavigator: false,
      initialItemId: false
    }
  },
  getters: {
    getItemsList: state => state.itemsList,
    getItemsLoading: state => state.loading,
    getTableSpecifications: state => state.tableSpecifications,
    getMaxPages: state => state.maxPages,
    getMeta: state => state.meta,
    getSelectedStore: state => state.selectedStore,
    getSelectedStoreIndex: state => {
      if (!state.selectedStore) return 0
      const index = state.itemsList.findIndex(i => i.id === state.selectedStore.id)
      return index
    },
    getUpdateStoreLoading: state => state.updateStoreLoading,
    getEditedStore: state => state.editedStore,
    getAllFields: state => [...state.nonAddressFields, ...state.addressFields],
    getSomethingWasChanged: (state, getters) => {
      let selected = {}
      let edited = {}
      const allFields = getters.getAllFields

      allFields.forEach(field => {
        selected[field] = (state.selectedStore && state.selectedStore[field]) || ''
        edited[field] = (state.editedStore && state.editedStore[field]) || ''
      })

      return !isEqual(selected, edited)
    },
    getAddressWasChanged: (state) => {
      let selected = {}
      let edited = {}

      state.addressFields.forEach(field => {
        selected[field] = state.selectedStore[field] || ''
        edited[field] = state.editedStore[field] || ''
      })

      return !isEqual(selected, edited)
    },
    getPreviewImage: state => state.previewImage,
    getFormIsValid: state => state.formIsValid,
    getBrandByIdLoading: state => state.brandByIdLoading,

    getStoreDrawer: state => state.storeDrawer
  },
  mutations: {
    SET_ITEMS_LIST (state, value) {
      state.itemsList = value
    },
    SET_LOADING (state, value) {
      state.loading = value
    },
    SET_ITEMS_LIST_ITEM (state, { value, index }) {
      Vue.prototype.$set(state.itemsList, index, value)
    },
    SET_TABLE_SPECIFICATIONS (state, value) {
      state.tableSpecifications = value
    },
    SET_MAX_PAGES (state, value) {
      state.maxPages = value
    },
    SET_META (state, value) {
      state.meta = value
    },
    SET_SELECTED_STORE (state, value) {
      state.selectedStore = value
    },
    SET_UPDATE_STORE_LOADING (state, value) {
      state.updateStoreLoading = value
    },
    SET_EDITED_STORE (state, value) {
      state.editedStore = value
    },
    SET_EDITED_STORE_LOGO (state, value) {
      Vue.prototype.$set(state.editedStore, 'logo_url', value)
    },
    SET_PREVIEW_IMAGE (state, value) {
      state.previewImage = value
    },
    SET_FORM_IS_VALID (state, value) {
      state.formIsValid = value
    },
    SET_BRAND_BY_ID_LOADING (state, value) {
      state.brandByIdLoading = value
    },
    SET_SELECTED_STORE_FIELD (state, { field, value }) {
      Vue.prototype.$set(state.selectedStore, field, value)
    },
    SET_STORE_DRAWER_FIELD (state, { field, value }) {
      Vue.prototype.$set(state.storeDrawer, field, value)
    }
  },
  actions: {
    async getItemsRequest ({ commit }, query) {
      try {
        commit('SET_LOADING', true)
        const response = await getAllStores(query)

        if (response?.data) commit('SET_ITEMS_LIST', response.data)
        if (response?.table_specifications) commit('SET_TABLE_SPECIFICATIONS', response.table_specifications)
      } catch (e) {
        throw e
      } finally {
        commit('SET_LOADING', false)
      }
    },
    async getMetaRequest ({ commit }, query) {
      try {
        const response = await getAllStores(query)
        if (response?.meta?.last_page) commit('SET_MAX_PAGES', response.meta.last_page)
        if (response.meta) commit('SET_META', response.meta)
      } catch (e) {
        throw e
      }
    },
    async loadTableSpecifications ({ commit }, query) {
      try {
        const response = await getAllStores(query)

        if (response.data?.table_specifications) commit('SET_TABLE_SPECIFICATIONS', response.data.table_specifications)
        return Promise.resolve()
      } catch (e) {
        throw e
      }
    },
    setEditedStore ({ commit }, value) {
      commit('SET_EDITED_STORE', value)
    },
    setSelectedStoreField ({ commit }, field, value) {
      commit('SET_SELECTED_STORE_FIELD', { field, value })
    }
  }
}
