import moment from 'moment-timezone'
import { fetchSalesOrderFulfillmentsByType } from '@/services/orders/SalesOrdersService'

export const ShippingProviderDashboardModule = {
  namespaced: true,
  state: () => ({
    startDate: moment().subtract(1, 'months').startOf('day'),
    endDate: moment(),
    shipments: [],
    shipmentsLoading: false
  }),
  getters: {
    getSelectedMetric: state => state.selectedMetric,
    getStartDate: state => state.startDate,
    getEndDate: state => state.endDate,
    getShipments: state => state.shipments,
    getShipmentsLoading: state => state.shipmentsLoading
  },
  mutations: {
    SET_START_DATE (state, value) {
      state.startDate = value
    },
    SET_END_DATE (state, value) {
      state.endDate = value
    },
    SET_SHIPMENTS (state, value) {
      state.shipments = value
    },
    SET_SHIPMENTS_LOADING (state, value) {
      state.shipmentsLoading = value
    }
  },
  actions: {
    /**
     * Loads shipstation shipments
     */
    async loadShipments ({ commit, state }, type) {
      commit('SET_SHIPMENTS_LOADING', true)
      try {
        const response = await fetchSalesOrderFulfillmentsByType(
          type,
          state.startDate.format('YYYY-MM-DD'),
          state.endDate.format('YYYY-MM-DD')
        )
        commit('SET_SHIPMENTS', response.data)
      } catch (e) {
        return Promise.reject(e)
      } finally {
        commit('SET_SHIPMENTS_LOADING', false)
      }
    }
  }
}
