import Vue from 'vue'
import {fetchSmoInvoiceByID, fetchSmoInvoices} from '../../services/shipmyorders/ShipMyOrdersInvoicesService'

export const ShipMyOrdersInvoicesModule = {
  namespaced: true,
  state: {
    invoices: {
      itemsList: [],
      tableSpecifications: {},
      maxPages: 0,
      meta: {},
      loading: false
    },
    selectedItem: {},
    drawerMode: 'view',
    smoDrawer: {
      show: false,
      hideNavigator: false,
      initialItemId: false
    },
    globalSettings: null,
    isFetch: false,
    smoLoading: false
  },
  getters: {
    getItemsList: state => state.invoices.itemsList,
    getTableSpecifications: state => state.invoices.tableSpecifications,
    getMaxPages: state => state.invoices.maxPages,
    getMeta: state => state.invoices.meta,
    getSelectedItem: state => state.selectedItem,
    getSelectedItemIndex: state => {
      if (!state.selectedItem || !state.invoices.itemsList.length) { return -1 }
      return state.invoices.itemsList.findIndex(i => i.id === state.selectedItem.id)
    },
    getLoading: state => state.invoices.loading,
    getDrawerMode: state => state.drawerMode,
    getShipMyOrdersInvoiceDrawer: state => state.smoDrawer,
    getSMOLoading: state => state.smoLoading
  },
  mutations: {
    SET_SMO_INVOICES_ITEMS_LIST (state, value) {
      Vue.prototype.$set(state.invoices, 'itemsList', value)
    },
    SET_SMO_INVOICES_TABLE_SPECIFICATIONS (state, value) {
      Vue.prototype.$set(state.invoices, 'tableSpecifications', value)
    },
    SET_SMO_INVOICES_MAX_PAGES (state, value) {
      Vue.prototype.$set(state.invoices, 'maxPages', value)
    },
    SET_SMO_INVOICES_LOADING (state, value) {
      Vue.prototype.$set(state.invoices, 'loading', value)
    },
    SET_SMO_INVOICES_SELECT_INVOICE (state, value) {
      Vue.prototype.$set(state, 'selectedItem', value)
    },
    SET_SMO_INVOICES_META (state, value) {
      Vue.prototype.$set(state.invoices, 'meta', value)
    },
    SET_GLOBAL_SETTINGS (state, value) {
      state.globalSettings = value
    },
    SET_IS_FETCH (state, value) {
      state.isFetch = value
    },
    SET_DRAWER_MODE (state, value) {
      state.drawerMode = value
    },
    SET_SMO_DRAWER_FIELD (state, { field, value }) {
      Vue.prototype.$set(state.smoDrawer, field, value)
    },
    SET_SMO_LOADING (state, value) {
      Vue.prototype.$set(state, 'smoLoading', value)
    }
  },
  actions: {
    async setSelectedInvoice ({ commit }, ID) {
      try {
        if (ID === null) {
          commit('SET_SMO_INVOICES_SELECT_INVOICE', null)
          return
        }
        commit('SET_SMO_LOADING', true)
        const { data } = await fetchSmoInvoiceByID(ID)

        commit('SET_SMO_INVOICES_SELECT_INVOICE', data)
      } catch (e) {
        throw e
      } finally {
        commit('SET_SMO_LOADING', false)
      }
    },
    async getItemsRequest ({ commit }, query) {
      try {
        commit('SET_SMO_INVOICES_LOADING', true)
        const response = await fetchSmoInvoices(query)

        commit('SET_SMO_INVOICES_ITEMS_LIST', response.data)
        if (response.table_specifications) commit('SET_SMO_INVOICES_TABLE_SPECIFICATIONS', response.table_specifications)
      } catch (e) {
        throw e
      } finally {
        commit('SET_SMO_INVOICES_LOADING', false)
      }
    },
    async getMetaRequest ({ commit, state }, query) {
      try {
        const response = await fetchSmoInvoices(query)
        if (response.meta && response.meta.last_page) commit('SET_SMO_INVOICES_MAX_PAGES', response.meta.last_page)
        if (response.meta) commit('SET_SMO_INVOICES_META', response.meta)
      } catch (e) {
        throw e
      }
    },
    async loadTableSpecifications ({ commit }, query) {
      try {
        const response = await fetchSmoInvoices(query)

        if (response.data?.table_specifications) commit('SET_SMO_INVOICES_TABLE_SPECIFICATIONS', response.data.table_specifications)
        return Promise.resolve()
      } catch (e) {
        throw e
      }
    }
  }
}
