import { settingsPurchaseOrders } from '@/services/orders/PurchaseOrdersService'
import { PO_SETTING_KEYS } from '@/assets/constants'

export const SettingsPurchaseOrders = {
  namespaced: true,
  state: {
    settings: [],
    loading: false
  },
  getters: {
    getSettings: state => state.settings,
    getLoading: state => state.loading,
    getSettingByKey: (_,getters) => (key, emptyValue = null) => {
      const setting = getters.getSettings.find(s => s.key === key)
      return setting? setting.value : emptyValue
    },
    getFormat: (_,getters) => getters.getSettingByKey(PO_SETTING_KEYS.FORMAT),
    getDigits: (_,getters) => getters.getSettingByKey(PO_SETTING_KEYS.NUM_DIGITS, ''),
    getPrefix: (_,getters) => getters.getSettingByKey(PO_SETTING_KEYS.PREFIX, ''),
    getStartNumber: (_,getters) => getters.getSettingByKey(PO_SETTING_KEYS.START_NUMBER, ''),
    getStore: (_,getters) => getters.getSettingByKey(PO_SETTING_KEYS.STORE),
    getWarehouse: (_,getters) => getters.getSettingByKey(PO_SETTING_KEYS.WAREHOUSE),
    getShippingMethod: (_,getters) => getters.getSettingByKey(PO_SETTING_KEYS.SHIPPING_METHOD),
    getPaymentType: (_,getters) => getters.getSettingByKey(PO_SETTING_KEYS.PAYMENT_TYPE),
    getLeadType: (_,getters) => getters.getSettingByKey(PO_SETTING_KEYS.LEAD_TIME, ''),
    getCCOutgoing: (_,getters) => getters.getSettingByKey(PO_SETTING_KEYS.CC_OUTGOING, ''),
    getBuilderRoundingMethod: (_,getters) => getters.getSettingByKey(PO_SETTING_KEYS.BUILDER_ROUNDING_METHOD),
    getBuilderUseMoq: (_,getters) => getters.getSettingByKey(PO_SETTING_KEYS.BUILDER_USE_MOQ),
    getBuilderUseLeadTime: (_,getters) => getters.getSettingByKey(PO_SETTING_KEYS.BUILDER_USE_LEAD_TIME),
    getBuilderForecastType: (_,getters) => getters.getSettingByKey(PO_SETTING_KEYS.BUILDER_FORECAST_TYPE),
    getBuilderTargetQuantity: (_,getters) => getters.getSettingByKey(PO_SETTING_KEYS.BUILDER_TARGET_QUANTITY),
    getBuilderSalesHistory: (_,getters) => getters.getSettingByKey(PO_SETTING_KEYS.BUILDER_SALES_HISTORY),
    getBuilderTargetDaysStock: (_,getters) => getters.getSettingByKey(PO_SETTING_KEYS.BUILDER_TARGET_DAYS_OF_STOCK),
  },
  mutations: {
    SET_SETTINGS (state, value) {
      state.settings = value
    },
    SET_LOADING (state, value) {
      state.loading = value
    }
  },
  actions: {
    async fetchSettings ({ commit, getters }, query) {
      if (getters.getLoading) return
      try {
        commit('SET_LOADING', true)

        const response = await settingsPurchaseOrders(query)
        commit('SET_SETTINGS', response.data)
      } catch (e) {
        throw e
      } finally {
        commit('SET_LOADING', false)
      }
    }
  }
}
