// import { settingsPurchaseOrders } from '@/services/orders/PurchaseOrdersService'
// import { PO_SETTING_KEYS } from '@/assets/constants'

export const SettingsAccounting = {
  namespaced: true,
  state: {
    settings: [],
    loading: false
  },
  getters: {
    getSettings: state => state.settings,
    getLoading: state => state.loading,
    getSettingByKey: (_,getters) => (key, emptyValue = null) => {
      const setting = getters.getSettings.find(s => s.key === key)
      return setting? setting.value : emptyValue
    },
  },
  mutations: {
    SET_SETTINGS (state, value) {
      state.settings = value
    },
    SET_LOADING (state, value) {
      state.loading = value
    }
  },
  actions: {
    async fetchSettings ({ commit, getters }, query) {
      if (getters.getLoading) return
      try {
        commit('SET_LOADING', true)

        const response = await settingsPurchaseOrders(query)
        commit('SET_SETTINGS', response.data)
      } catch (e) {
        throw e
      } finally {
        commit('SET_LOADING', false)
      }
    }
  }
}
