import { getSalesOrderLinesFinancials } from '@/services/FinancialsService'
import { getTableMetaRequest, getTableSpecificationsRequest, getItemsRequest } from '@/support/tableApiRequestHelpers'
import {lookupSalesOrderLineFinancialsValues} from "@/services/LookupService";

export const SalesOrderLinesFinancialsModule = {
  namespaced: true,
  state: {
    itemsList: [],
    tableSpecifications: {},
    maxPages: 0,
    meta: {},
    loading: false,
    selectedItem: null,
  },
  getters: {
    getItemsList: state => state.itemsList,
    getTableSpecifications: state => state.tableSpecifications,
    getMaxPages: state => state.maxPages,
    getMeta: state => state.meta,
    getLoading: state => state.loading,
    getSelectedItem: state => state.selectedItem,
    getSelectedItemIndex: state => {
      if (!state.selectedItem) return 0
      return state.itemsList.findIndex(i => i.id === state.selectedItem.id)
    },
  },
  mutations: {
    SET_ITEMS_LIST (state, value) {
      state.itemsList = value
    },
    SET_TABLE_SPECIFICATIONS (state, value) {
      state.tableSpecifications = value
    },
    SET_MAX_PAGES (state, value) {
      state.maxPages = value
    },
    SET_META (state, value) {
      state.meta = value
    },
    SET_LOADING (state, value) {
      state.loading = value
    },
    SET_SELECTED_ITEM (state, value) {
      state.selectedItem = value
    },
  },
  actions: {
    async getItemsRequest ({ commit }, query) {
      return getItemsRequest(query, commit, getSalesOrderLinesFinancials)
    },
    async getMetaRequest ({ commit }, query) {
      return getTableMetaRequest(query, commit, getSalesOrderLinesFinancials)
    },
    async loadTableSpecifications ({ commit }, query) {
      return getTableSpecificationsRequest(query, commit, getSalesOrderLinesFinancials)
    },
    async fetchLookupValues ({ commit }, { value, header, page = 0, limit = 10 }) {
      try {
        return await lookupSalesOrderLineFinancialsValues({ value, header, page, limit })
      } catch (e) {
        throw e
      }
    },
  }
}
