import { getAllPurchaseOrders } from '@/services/orders/PurchaseOrdersService'
import { lookupPurchaseOrdersValues } from '@/services/LookupService'

export const PurchaseOrdersTableModule = {
  namespaced: true,
  state: () => ({
    itemsList: [],
    maxPages: 0,
    meta: {},
    tableConfiguration: {},
    loading: false
  }),
  getters: {
    getTableSpecifications: state => state.tableConfiguration,
    getItemsList: state => state.itemsList,
    getMaxPages: state => Number(state.maxPages),
    getMeta: state => state.meta,
    getLoading: state => state.loading
  },
  mutations: {
    SET_ALL_ITEMS (state, products) {
      state.itemsList = products
    },
    SET_TABLE_CONFIGURATION (state, config) {
      state.tableConfiguration = config
    },
    SET_MAX_PAGES (state, pages) {
      state.maxPages = pages
    },
    SET_META (state, meta) {
      state.meta = meta
    },
    SET_LOADING (state, value) {
      state.loading = value
    }
  },
  actions: {
    async getItemsRequest ({ commit }, query) {
      try {
        commit('SET_LOADING', true)
        const response = await getAllPurchaseOrders(query)
        if (!response) return
        if (response.hasOwnProperty('data')) commit('SET_ALL_ITEMS', response.data)
        if (response.hasOwnProperty('table_specifications')) commit('SET_TABLE_CONFIGURATION', response.table_specifications)
      } catch (e) {
        throw e
      } finally {
        commit('SET_LOADING', false)
      }
    },

    async getMetaRequest ({ commit }, query) {
      try {
        const response = await getAllPurchaseOrders(query)
        if (response?.meta && response.meta?.last_page) commit('SET_MAX_PAGES', response.meta.last_page)
        if (response?.meta) commit('SET_META', response.meta)
      } catch (e) {
        throw e
      }
    },

    async loadTableSpecifications ({ commit }, query) {
      try {
        const response = await getAllPurchaseOrders(query)

        if (response.data?.table_specifications) commit('SET_TABLE_CONFIGURATION', response.data.table_specifications)
        return Promise.resolve()
      } catch (e) {
        throw e
      }
    },

    async fetchLookupPurchaseOrdersValues ({ commit }, { value, header, page = 0, limit = 10 }) {
      try {
        return await lookupPurchaseOrdersValues({ value, header, page, limit })
      } catch (e) {

      }
    }
  }
}
