import Vue from 'vue'
import { uniqBy } from 'lodash'
export const PurchaseOrderReceiptModule = {
  namespaced: true,
  state: {
    selectedItem: null,
    purchaseOrderReceiptDrawer: {
      show: false,
      hideNavigator: false,
      initialItemId: ''
    },

    somethingChanged: false,

    drawerMode: null, // create, edit and view
    receiptItems: [],
    purchaseOrder: {
      item: null,
      initialValuesAreSet: false,
      barcode: null,
      orderProducts: [],
    },
    parentUid: null,
    fetchingProducts: false,
    receiptItemsByProduct: new Map(),
  },
  getters: {
    getSelectedItem: state => state.selectedItem,
    getPurchaseOrderReceiptDrawer: state => state.purchaseOrderReceiptDrawer,
    getSomethingChanged: state => state.somethingChanged,
    getDrawerMode: state => state.drawerMode,
    getReceiptItems: state => state.receiptItems,
    getReceiptItemsByProductId: (state) => (id) => {
      const res = state.receiptItems.reduce((acc, item) => {
        if (item.hasOwnProperty('purchase_order_shipment_receipt_lines')) {
          const filteredReceiptByProduct = item.purchase_order_shipment_receipt_lines
            .filter( line => {
              if (!line.hasOwnProperty('purchase_order_line')) return false
              return line.purchase_order_line.id === id
            })

          if (filteredReceiptByProduct.length) {
            acc.push(...filteredReceiptByProduct.map(({quantity}) => ({
              id: item.id || null,
              quantity: quantity || 0
            }))
            )
          }
        }
        return acc
      }, [])
      return res
    },
    getMissingItems: (state) => {
      let allLineItems = []
      state.receiptItems.forEach(item => {
        allLineItems = [...allLineItems, ...item.purchase_order_shipment_receipt_lines]
      })

      allLineItems = allLineItems.map(i => {
        const pending = i.purchase_order_line.quantity - i.purchase_order_line.received_quantity
        i.purchase_order_line.receive_quantity = pending
        i.purchase_order_line.pending = pending
        i.purchase_order_line.name = i.purchase_order_line.description
        i.purchase_order_line.sku = i.purchase_order_line.product
        return i.purchase_order_line
      })
      // array of unique lines
      let uniqueLineItems = uniqBy(allLineItems, 'id')

      // we need to include purchase order lines which were never received
      // create array of such items and add them to existing array
      let neverReceivedItems = []
      state.purchaseOrder.item?.items.forEach(i => {
        const receivedItem = uniqueLineItems.find(u => u.id === i.id)
        if (!receivedItem) {
          let clone = JSON.parse(JSON.stringify(i))
          clone.receive_quantity = clone.quantity
          clone.pending = clone.quantity
          neverReceivedItems.push(clone)
        }
      })
      return [...uniqueLineItems, ...neverReceivedItems].filter(i => i.pending > 0 && i.sku && i.sku.id)
    },
    getSelectedPurchaseOrder : state => state.purchaseOrder.item,
    getOrderProducts : state => state.purchaseOrder.orderProducts,
    getInitialValuesAreSet : state => state.purchaseOrder.initialValuesAreSet,
    getShowBarcode: state => state.purchaseOrder.barcode,
    getParentUid: state => state.parentUid,
    getReceiptItemsByProductId: state => lineId => state.receiptItemsByProduct.has(lineId) ? state.receiptItemsByProduct.get(lineId) : [],
    isFetchingProducts: state => state.fetchingProducts,
  },
  mutations: {
    SET_SELECTED_ITEM (state, value) {
      state.selectedItem = value
    },
    SET_PURCHASE_INVOICE_DRAWER_FIELD (state, { field, value }) {
      Vue.prototype.$set(state.purchaseOrderReceiptDrawer, field, value)
    },
    SET_SOMETHING_CHANGED (state, value) {
      state.somethingChanged = value
    },
    SET_DRAWER_MODE (state, value) {
      state.drawerMode = value
    },
    SET_RECEIPT_ITEMS (state, value) {
      state.receiptItems = value
    },
    SET_SELECTED_PO (state, value) {
      Vue.prototype.$set(state.purchaseOrder, 'item', value)
    },
    SET_PURCHASE_ORDER_FIELDS (state, { field, value }) {
      Vue.prototype.$set(state.purchaseOrder, field, value)
    },
    SET_PARENT_UID (state, value) {
      state.parentUid = value
    },
    SET_FETCH_PRODUCTS (state, value) {
      state.fetchingProducts = value
    },
    SET_RECEIPT_ITEMS_BY_PRODUCT (state, value) {
      state.receiptItemsByProduct = value
    },
  }
}
