import Vue from 'vue'

export const PurchaseAddProductModule = {
  namespaced: true,
  state: {
    supplier: null,
    globalSettings: null,
    purchaseAddProductDrawerMode: 'add',
    purchaseAddProductDrawer: {
      mode: null,
      show: false
    },
    parentUid: null,
  },
  getters: {
    getSelectedSupplier: state => state.supplier,
    getPurchaseAddProductDrawerMode: state => state.purchaseAddProductDrawerMode,
    getPurchaseAddProductDrawer: state => state.purchaseAddProductDrawer,
    getShowBarcode: state => {
      if (!state.globalSettings) return false
      const barcodeObj = state.globalSettings.find(i => i.key === 'sales_credit_show_barcode_in_frontend')
      if (!barcodeObj) return false
      return barcodeObj.value
    },
    getParentUid: state => state.parentUid,
  },
  mutations: {
    SET_PURCHASE_ADD_PRODUCT_DRAWER_FIELD (state, { value, field }) {
      Vue.prototype.$set(state.purchaseAddProductDrawer, field, value)
    },
    SET_PURCHASE_ADD_PRODUCT_DRAWER_MODE (state, value) {
      state.purchaseAddProductDrawerMode = value
    },
    SET_GLOBAL_SETTINGS (state, value) {
      state.globalSettings = value
    },
    SET_SUPPLIER (state, value) {
      state.supplier = value
    },
    SET_PARENT_UID (state, value) {
      state.parentUid = value
    },
  },
  actions: {

  }
}
