import { getAllProducts } from '@/services/ProductsService'
import { lookupProductValues } from '@/services/LookupService'

export const ProductsFiltersModule = {
  namespaced: true,
  state: () => ({
    productsTableConfiguration: {}
  }),
  getters: {
    getTableSpecifications: state => state.productsTableConfiguration
  },
  mutations: {
    SET_PRODUCTS_TABLE_CONFIGURATION (state, config) {
      state.productsTableConfiguration = config
    }
  },
  actions: {
    async getItemsRequest ({ commit }, query) {
      let localQuery = Object.assign({}, query)
      // only fetch specifications without products
      localQuery.specifications = '1'
      try {
        const response = await getAllProducts(localQuery)
        if (response.data.table_specifications) commit('SET_PRODUCTS_TABLE_CONFIGURATION', response.data.table_specifications)
      } catch (e) {
        throw e
      }
    },

    async fetchLookupProductValues ({ commit }, { value, header, page = 0, limit = 10 }) {
      try {
        return await lookupProductValues({ value, header, page, limit })
      } catch (e) {

      }
    }
  }
}
