import { getCategoriesTree, getAllProductCategories } from '../../services/ProductsTaxonomyService'
import Vue from 'vue'

export const ProductsCategoryModule = {
  namespaced: true,
  state: {
    path: [],
    // selectedCategory: {},
    // displayLevel: 0,
    // parentIndex: [0], // A path of selected parent indexes for back navigation
    // selectedIndex: 0,
    loading: false,
    // startPage: 1,
    // pageCount: 1,
    // endPage: 1,
    itemsList: [],
    tableSpecifications: {},
    maxPages: 0,
    meta: {},
    showCategoryModal: false,
    itemsLoading: false
  },
  getters: {
    getCategories: state => state.path, // We get the categories on the path at the current level.
    // getPath: state => state.path,
    // getSelectedCategory: state => state.selectedCategory,
    // getDisplayLevel: state => state.displayLevel,
    // getParentIndex: state => state.parentIndex,
    // getSelectedIndex: state => state.selectedIndex,
    getLoading: state => state.loading,
    getItemsLoading: state => state.itemsLoading,
    // getStartPage: state => state.startPage,
    // getEndPage: state => state.endPage,
    // getPageCount: state => state.pageCount,
    getItemsList: state => state.itemsList,
    getTableSpecifications: state => state.tableSpecifications,
    getMaxPages: state => state.maxPages,
    getMeta: state => state.meta,
    getShowCategoryModal: state => state.showCategoryModal
  },
  mutations: {
    SET_LOADING (state, loading) {
      state.loading = loading
    },
    SET_ITEMS_LOADING (state, value) {
      state.itemsLoading = value
    },
    SET_PATH (state, path) {
      state.path = path
    },
    SET_ITEMS_LIST (state, value) {
      state.itemsList = value
    },
    SET_TABLE_SPECIFICATIONS (state, value) {
      state.tableSpecifications = value
    },
    SET_MAX_PAGES (state, value) {
      state.maxPages = value
    },
    SET_META (state, value) {
      state.meta = value
    },
    SET_ITEM_AT (state, payload) {
      // We update the item at the given index
      Vue.set(state.itemsList, payload.index, payload.item)
    },
    SET_SHOW_CATEGORY_MODAL (state, value) {
      state.showCategoryModal = value
    }
  },
  actions: {
    async initializeCategoryTree ({ commit }) {
      // In the beginning, we fetch the categories tree from
      // the api and set them as the categories at
      // the current (initial) display level.
      commit('SET_LOADING', true)
      const categories = await getCategoriesTree()
      commit('SET_PATH', categories)
      commit('SET_LOADING', false)
    },

    /**
     * Gets paginated product categories.
     * @param commit
     * @param query
     * @returns {Promise<void>}
     */
    async getItemsRequest ({ commit }, query) {
      try {
        commit('SET_ITEMS_LOADING', true)
        const response = await getAllProductCategories(query)
        // We set the items list
        commit('SET_ITEMS_LIST', response.data)
        // Next, we set the table specifications if available
        if (response.table_specifications) commit('SET_TABLE_SPECIFICATIONS', response.table_specifications)
      } catch (e) {
        throw e
      } finally {
        commit('SET_ITEMS_LOADING', false)
      }
    },
    async getMetaRequest ({ commit }, query) {
      try {
        const response = await getAllProductCategories(query)
        if (response.meta && response.meta.last_page) commit('SET_MAX_PAGES', response.meta.last_page)
        if (response.meta) commit('SET_META', response.meta)
      } catch (e) {
        throw e
      }
    },
    async loadTableSpecifications ({ commit }, query) {
      try {
        const response = await getAllProductCategories(query)

        if (response.data?.table_specifications) commit('SET_TABLE_SPECIFICATIONS', response.data.table_specifications)
        return Promise.resolve()
      } catch (e) {
        throw e
      }
    },
  }
}
