import { isEqual } from 'lodash'
import Vue from 'vue'

export const ProductListingsInventoryModule = {
  namespaced: true,
  state: {
    initialValue: null,
    editingValue: null
  },
  getters: {
    getInitialValue: state => state.initialValue,
    getEditingValue: state => state.editingValue,
    getInventorySettingsChanged: state => {
      return !isEqual(state.initialValue, state.editingValue)
    },
    getSkuIsMasterOfStock: state => {
      return state.editingValue.master_of_stock === 'sku.io'
    },
    getHasInventoryLocations: state => {
      const inventory = state.editingValue.inventory_rules || state.editingValue.sales_channel_settings.inventory
      if (!inventory) {
        return false
      }

      return inventory.locations !== undefined && inventory.locations.length > 0
    }
  },
  mutations: {
    SET_INITIAL_VALUE: (state, value) => {
      state.initialValue = value
    },
    SET_EDITING_VALUE: (state, value) => {
      state.editingValue = value
    },
    SET_EDITING_VALUE_FIELD: (state, { field, value }) => {
      Vue.prototype.$set(state.editingValue, field, value)
      if (field === 'master_of_stock' && state.editingValue.inventory_rules !== null) {
        Vue.prototype.$set(state.editingValue.inventory_rules, 'masterOfStock', value)
      }
    },
    SET_EDITING_VALUE_LOCATIONS: (state, locations) => {
      Vue.prototype.$set(state.editingValue, 'locations', locations)
    }
  }
}
