import { getPaymentTypes } from '@/services/PaymentTypesService'

export const PaymentTypesModule = {
  namespaced: true,
  state: {
    types: [],
  },
  getters: {
    getPaymentTypes: state => state.types.map(type => ({ text: type.name, value: type.id })),
  },
  mutations: {
    SET_PAYMENT_TYPES (state, value) {
      state.types = value
    }
  },
  actions: {
    async fetchPaymentTypes ({commit}) {
      try {
        const {data} = await getPaymentTypes()
        commit('SET_PAYMENT_TYPES', data)
      } catch (e) {
        return Promise.reject(e)
      }
    }
  }
}
