import { getAllFulfillments } from '../../services/orders/FulfillmentsService'
import { lookupFulfillmentsValues } from '@/services/LookupService'
import Vue from 'vue'

const DRAWER_MODES = {
  CREATE: 'create',
  VIEW: 'view',
  EDIT: 'edit',
  FULFILL: 'fulfill'
}

export const OrderFulfillmentModule = {
  namespaced: true,
  state: {
    itemsList: [],
    tableSpecifications: {},
    maxPages: 0,
    meta: {},
    itemsLoading: false,
    selectedItem: null,
    orderFulfillmentDrawer: {
      show: false,
      hideNavigator: false,
      initialItemId: false
    },
    selectedOrder: null,
    somethingChanged: false,
    fulfillmentNumber: null,

    fulfillmentModal: {
      show: false,
      warehouse: null,
      products: [],
      isDropship: false
    },

    drawerMode: null // create, edit, view, and fulfill
  },
  getters: {
    getMeta: state => state.meta,
    getMaxPages: state => state.maxPages,
    getItemsList: state => state.itemsList,
    getLoading: state => state.itemsLoading,
    getSelectedItem: state => state.selectedItem,
    getOrderFulfillmentDrawer: state => state.orderFulfillmentDrawer,
    getSomethingChanged: state => state.somethingChanged,
    getFulfillmentModal: state => state.fulfillmentModal,
    getDrawerMode: state => state.drawerMode,
    getSelectedOrder: state => state.selectedOrder,
    getTableSpecifications: state => state.tableSpecifications,
    getFulfillmentNumber: state => state.fulfillmentNumber,
    getDrawerModeValues: () => DRAWER_MODES,
    isFulfillmentMode: state => state.drawerMode === DRAWER_MODES.FULFILL,
    isCreateMode: state => state.drawerMode === DRAWER_MODES.CREATE,
    isViewMode: state => state.drawerMode === DRAWER_MODES.VIEW,
    isEditMode: state => state.drawerMode === DRAWER_MODES.EDIT,
  },
  mutations: {
    SET_ITEMS_LIST (state, items) {
      state.itemsList = JSON.parse(JSON.stringify(items))
    },
    SET_TABLE_SPECIFICATIONS (state, specs) {
      state.tableSpecifications = specs
    },
    SET_MAX_PAGES (state, pages) {
      state.maxPages = pages
    },
    SET_META (state, meta) {
      state.meta = meta
    },
    SET_ITEMS_LOADING (state, value) {
      state.itemsLoading = value
    },
    SET_SELECTED_ITEM (state, value) {
      state.selectedItem = value
    },
    SET_SELECTED_ORDER (state, value) {
      state.selectedOrder = value
    },
    SET_ORDER_FULFILLMENT_DRAWER_FIELD (state, { field, value }) {
      Vue.prototype.$set(state.orderFulfillmentDrawer, field, value)
    },
    SET_FULFILLMENT_MODAL (state, value) {
      state.fulfillmentModal = value
    },
    SET_SOMETHING_CHANGED (state, value) {
      state.somethingChanged = value
    },
    SET_FULFILLMENT_MODAL_FIELD (state, { field, value }) {
      Vue.prototype.$set(state.fulfillmentModal, field, value)
    },
    SET_DRAWER_MODE (state, value) {
      state.drawerMode = value
    },
    SET_FULFILLMENT_NUMBER (state, value) {
      state.fulfillmentNumber = value
    }
  },
  actions: {
    async getItemsRequest ({ commit, state }, query) {
      try {
        commit('SET_ITEMS_LOADING', true)
        const response = await getAllFulfillments(query)

        if (response.data) commit('SET_ITEMS_LIST', response.data)
        if (response.table_specifications) commit('SET_TABLE_SPECIFICATIONS', response.table_specifications)
      } catch (e) {
        throw e
      } finally {
        commit('SET_ITEMS_LOADING', false)
      }
    },
    async getMetaRequest ({ commit }, query) {
      try {
        const response = await getAllFulfillments(query)
        if (response.meta && response.meta.last_page) commit('SET_MAX_PAGES', response.meta.last_page)
        if (response.meta) commit('SET_META', response.meta)
      } catch (e) {
        throw e
      }
    },
    async loadTableSpecifications ({ commit }, query) {
      try {
        const response = await getAllFulfillments(query)

        if (response.data?.table_specifications) commit('SET_TABLE_SPECIFICATIONS', response.data.table_specifications)
        return Promise.resolve()
      } catch (e) {
        throw e
      }
    },
    async fetchLookupValues ({ commit }, { value, header, page = 0, limit = 10 }) {
      try {
        return await lookupFulfillmentsValues({ value, header, page, limit })
      } catch (e) {

      }
    }
  },
}
