import { lookupProductValues } from '@/services/LookupService'
import { getAllSalesOrders } from '@/services/orders/SalesOrdersService'

export const OrderFiltersModule = {
  namespaced: true,
  state: () => ({
    productsTableConfiguration: {},
  }),
  getters: {
    getTableSpecifications: state => state.productsTableConfiguration,
    getCustomTableSpecifications: state => {
      let { columns = [] } = state.productsTableConfiguration
      columns = columns.filter(c => {
        return ['ship_by_date','deliver_by_date'].includes(c.data_name)
      })

      return { ...state.productsTableConfiguration, columns, default_sort: [], frozen_columns: [] }
    },
  },
  mutations: {
    SET_PRODUCTS_TABLE_CONFIGURATION (state, config) {
      state.productsTableConfiguration = config
    },
  },
  actions: {
    async getItemsRequest ({ commit }, query) {
      let localQuery = Object.assign({}, query)
      // only fetch specifications without products
      localQuery.specifications = '1'
      try {
        const {data} = await getAllSalesOrders(localQuery)
        if (data && data?.table_specifications) commit('SET_PRODUCTS_TABLE_CONFIGURATION', data.table_specifications)
      } catch (e) {
        throw e
      }
    },
    async fetchLookupProductValues ({ commit }, { value, header, page = 0, limit = 10 }) {
      try {
        return await lookupProductValues({ value, header, page, limit })
      } catch (e) {

      }
    },
  }
}
