export const ModalsModule = {
  namespaced: true,
  state: {
    openDialogsIds: []
  },
  getters: {
    getLastOpenDialogId: state => {
      if (!state.openDialogsIds.length) return null
      const lastIndex = state.openDialogsIds.length - 1
      return state.openDialogsIds[lastIndex]
    }
  },
  mutations: {
    PUSH_OPEN_DIALOG_ID (state, value) {
      state.openDialogsIds.push(value)
    },
    SLICE_OPEN_DIALOG_ID (state, value) {
      const index = state.openDialogsIds.findIndex(i => i === value)
      state.openDialogsIds.splice(index, 1)
    }
  }
}
