import Vue from 'vue'

export const IntegrationsDashboardModule = {
  namespaced: true,
  state: {
    loading: false,
    analytics: [],
    chart: [],
  },
  getters: {
    getDashboardLoading: state => state.loading,
    getDashboardAnalytics: state => state.analytics,
    getDashboardChartData: state => state.chart
  },
  mutations: {
    SET_DASHBOARD_DATA (state, {field,value}) {
      Vue.prototype.$set(state, field, value)
    }
  }
}
