import Vue from 'vue'

export const ImportModule = {
  namespaced: true,
  state: {
    importDrawer: {
      initialItemId: null,
      show: false
    },
    drawerMode: 'null'
  },
  getters: {
    getImportDrawer: state => state.importDrawer,
    getSelectedItem: state => state.selectedItem,
    getDrawerMode: state => state.drawerMode
  },
  mutations: {
    SET_IMPORT_DRAWER_FIELD (state, { value, field }) {
      Vue.prototype.$set(state.importDrawer, field, value)
    },
    SET_DRAWER_MODE (state, value) {
      state.drawerMode = value
    }
  }
}
