import Vue from 'vue'

export const ForecastingModule = {
  namespaced: true,
  state: {
    purchaseOrder: {
      ignoreItemResetOnLaunch: false,
      forecasting: null,
      supplier: null,
      order: null,
      eta: null,
      destinationWarehouse: null
    }
  },
  getters: {
    getPOIgnoreItem: state => state.purchaseOrder.ignoreItemResetOnLaunch,
    getPOForecasting: state => state.purchaseOrder.forecasting,
    getPOSupplier: state => state.purchaseOrder.supplier,
    getPOOrder: state => state.purchaseOrder.order,
    getPOEta: state => state.purchaseOrder.eta,
    getPODestinationWarehouse: state => state.purchaseOrder.destinationWarehouse
  },
  mutations: {
    SET_PURCHASE_ORDER_FIELD (state, { field, value }) {
      Vue.prototype.$set(state.purchaseOrder, field, value)
    }
  },
  actions: {

  }
}
