const dictionary = require('@/assets/enums.json')

// Import all of the dictionaries files.
function loadEnumDictionaries () {
  const context = require.context('@/assets/dictionaries', true, /.js$/i)
  return context.keys()
    .map(context)// import module
    .reduce((acc,module) => {
      acc = [...acc, ...module.default]
      return acc
    },[])
}

export const EnumsModule = {
  namespaced: true,
  state: {
    dictionary: [
      ...dictionary,
      ...loadEnumDictionaries(),
    ]
  },
  getters: {
    getDictionary: state => state.dictionary,

    getEnumText: state => ({ context, dataName, variableName }) => {
      if (!dataName) return null
      // Re-write data name
      // dataName = dataName.toString().replace(/\\/g, '-')
      // Fetch the user friendly name.
      // If the variable name is provided, we try to match it as well.
      const found = state.dictionary.find(row => {
        const baseCriterion = (row.context === context && row.data_name === dataName)

        if (variableName) { return baseCriterion && row.variable_name === variableName } else { return baseCriterion }
      })
      if (found) return found.friendly_name

      // We return the data name if not found
      return dataName
    },

    getAll: state => ({ context, variableName, textName = 'text' }) => {
      // Get all options for the context and variable name if available
      return state.dictionary.filter(row => {
        const baseCriterion = row.context === context

        if (variableName) return baseCriterion && row.variable_name === variableName
        else return baseCriterion
      }).map(row => {
        return { 'value': row.data_name, [textName]: row.friendly_name }
      })
    },

    getAllForVariable: state => ({ variable }) => {
      return state.dictionary.filter(row => row.variable_name === variable).map(row => ({
        value: row.data_name, text: row.friendly_name
      }))
    }
  }
}
