import Vue from 'vue'
import {getUserTemplates} from "../../services/EmailTemplatesService";

export const EmailTemplatesModule = {
  namespaced: true,
  state: {
    selectedItem: null,
    templates: [],
    emailTemplateDrawer: {
      show: false,
      hideNavigator: false,
      initialItemId: false
    },
    drawerMode: null,

    editedItem: {
      subject: '',
      html_body: '',
      enabled: '',
      type: ''
    },

    blurData: null,
    viewingHTML: false,

    wasSubjectLastFocused: false,

    variables: [
      { name: 'Sales Order #', variable: 'sales_order_number', types: ['sales_order_confirmation', 'sales_order_fulfilled', 'user_sales_order'] },
      { name: 'Order Status', variable: 'order_status', types: ['sales_order_confirmation', 'sales_order_fulfilled', 'user_sales_order'] },
      { name: 'Fulfillment Status', variable: 'fulfillment_status', types: ['sales_order_confirmation', 'sales_order_fulfilled', 'user_sales_order'] },
      { name: 'Customer Name', variable: 'customer_name', types: ['sales_order_confirmation', 'sales_order_fulfilled', 'sales_credit_issued', 'user_sales_order'] },

      // Shipping address
      { name: 'Customer Shipping Address', variable: 'shipping_address_full', types: ['sales_order_confirmation', 'sales_order_fulfilled', 'sales_credit_issued', 'user_sales_order'] },
      { name: 'Customer Shipping Address Name', variable: 'shipping_address_name', types: ['sales_order_confirmation', 'sales_order_fulfilled', 'sales_credit_issued', 'user_sales_order'] },
      { name: 'Customer Shipping Address Line 1', variable: 'shipping_address_address1', types: ['sales_order_confirmation', 'sales_order_fulfilled', 'sales_credit_issued', 'user_sales_order'] },
      { name: 'Customer Shipping Address Line 2', variable: 'shipping_address_address2', types: ['sales_order_confirmation', 'sales_order_fulfilled', 'sales_credit_issued', 'user_sales_order'] },
      { name: 'Customer Shipping Address Line 3', variable: 'shipping_address_address3', types: ['sales_order_confirmation', 'sales_order_fulfilled', 'sales_credit_issued', 'user_sales_order'] },
      { name: 'Customer Shipping Address City', variable: 'shipping_address_city', types: ['sales_order_confirmation', 'sales_order_fulfilled', 'sales_credit_issued', 'user_sales_order'] },
      { name: 'Customer Shipping Address Province Code', variable: 'shipping_address_province_code', types: ['sales_order_confirmation', 'sales_order_fulfilled', 'sales_credit_issued', 'user_sales_order'] },
      { name: 'Customer Shipping Address Zip/Postal Code', variable: 'shipping_address_postal_code', types: ['sales_order_confirmation', 'sales_order_fulfilled', 'sales_credit_issued'] },
      { name: 'Customer Shipping Address Country', variable: 'shipping_address_country', types: ['sales_order_confirmation', 'sales_order_fulfilled', 'sales_credit_issued'] },

      // Billing address
      { name: 'Customer Billing Address', variable: 'billing_address_full', types: ['sales_order_confirmation', 'sales_order_fulfilled'] },
      { name: 'Customer Billing Address Name', variable: 'billing_address_name', types: ['sales_order_confirmation', 'sales_order_fulfilled'] },
      { name: 'Customer Billing Address Line 1', variable: 'billing_address_address1', types: ['sales_order_confirmation', 'sales_order_fulfilled'] },
      { name: 'Customer Billing Address Line 2', variable: 'billing_address_address2', types: ['sales_order_confirmation', 'sales_order_fulfilled'] },
      { name: 'Customer Billing Address Line 3', variable: 'billing_address_address3', types: ['sales_order_confirmation', 'sales_order_fulfilled'] },
      { name: 'Customer Billing Address City', variable: 'billing_address_city', types: ['sales_order_confirmation', 'sales_order_fulfilled'] },
      { name: 'Customer Billing Address Province Code', variable: 'billing_address_province_code', types: ['sales_order_confirmation', 'sales_order_fulfilled'] },
      { name: 'Customer Billing Address Zip/Postal Code', variable: 'billing_address_postal_code', types: ['sales_order_confirmation', 'sales_order_fulfilled'] },
      { name: 'Customer Billing Address Country', variable: 'billing_address_country', types: ['sales_order_confirmation', 'sales_order_fulfilled'] },

      { name: 'Order Total', variable: 'total_revenue', types: ['sales_order_confirmation', 'sales_order_fulfilled'] },
      { name: 'Shipping Method', variable: 'shipping_method', types: ['sales_order_confirmation', 'sales_order_fulfilled', 'purchase_order', 'purchase_order_updated', 'user_purchase_order'] },
      { name: 'Payment Status', variable: 'payment_status', types: ['sales_order_confirmation', 'sales_order_fulfilled', 'sales_credit_issued'] },
      { name: 'Order Date', variable: 'order_date', types: ['sales_order_confirmation', 'sales_order_fulfilled'], isDate: true },
      { name: 'Payment Date', variable: 'payment_date', types: ['sales_order_confirmation', 'sales_order_fulfilled'], isDate: true },
      { name: 'Ship by Date', variable: 'ship_by_date', types: ['sales_order_confirmation', 'sales_order_fulfilled'] },
      { name: 'Deliver by Date', variable: 'deliver_by_date', types: ['sales_order_confirmation', 'sales_order_fulfilled'] },
      { name: 'Units Sold', variable: 'product_units', types: ['sales_order_confirmation', 'sales_order_fulfilled'] },
      { name: 'Additional Costs', variable: 'additional_cost', types: ['sales_order_confirmation', 'sales_order_fulfilled', 'purchase_order', 'purchase_order_updated', 'user_purchase_order'] },
      { name: 'Product Total', variable: 'product_total', types: ['sales_order_confirmation', 'sales_order_fulfilled'] },
      { name: 'Order Item List', variable: 'sales_order_lines', types: ['sales_order_confirmation', 'sales_order_fulfilled'] },
      { name: 'Tracking Number', variable: 'tracking_number', types: ['sales_order_confirmation', 'sales_order_fulfilled'] },
      { name: 'Shipping Cost', variable: 'shipping_cost', types: ['sales_order_confirmation', 'sales_order_fulfilled', 'sales_credit_issued'] },
      { name: 'Store Name', variable: 'store_name', types: ['sales_order_confirmation', 'sales_order_fulfilled', 'sales_credit_issued', 'purchase_order', 'user_sales_order', 'user_purchase_order'] },
      { name: 'Store Email', variable: 'store_email', types: ['sales_order_confirmation', 'sales_order_fulfilled', 'sales_credit_issued', 'user_sales_order'] },
      { name: 'Store Logo', variable: 'store_logo_url', types: ['sales_order_confirmation', 'sales_order_fulfilled', 'sales_credit_issued'] },
      { name: 'Sales Channel', variable: 'sales_channel', types: ['sales_order_confirmation', 'sales_order_fulfilled'] },

      { name: 'Originating Sales Order ID', variable: 'sales_order_number', types: ['sales_credit_issued'] },
      { name: 'Sales Credit ID', variable: 'sales_credit_number', types: ['sales_credit_issued'] },
      { name: 'Sales Credit Status', variable: 'credit_status', types: ['sales_credit_issued'] },
      { name: 'Sales Credit Date', variable: 'credit_date', types: ['sales_credit_issued'], isDate: true },
      { name: 'Credit Total', variable: 'total_revenue', types: ['sales_credit_issued'] },
      { name: 'Sales Order Date', variable: 'order_date', types: ['sales_credit_issued'], isDate: true },
      { name: 'Return Status', variable: 'return_status', types: ['sales_credit_issued'] },
      { name: 'Credit Item List', variable: 'sales_credit_lines', types: ['sales_credit_issued'] },
      { name: 'Return Reason', variable: 'return_reason', types: ['sales_credit_issued'] },

      { name: 'Purchase Order ID', variable: 'purchase_order_number', types: ['purchase_order', 'purchase_order_updated', 'user_purchase_order'] },
      { name: 'Order Status', variable: 'purchase_order_status', types: ['purchase_order', 'purchase_order_updated', 'user_purchase_order'] },
      { name: 'Supplier Name', variable: 'supplier_name', types: ['purchase_order', 'purchase_order_updated', 'bulk_purchase_order', 'user_purchase_order'] },
      { name: 'Supplier Contact Name', variable: 'primary_contact_name', types: ['purchase_order', 'purchase_order_updated', 'bulk_purchase_order', 'user_purchase_order'] },

      // Supplier address
      { name: 'Supplier Address', variable: 'supplier_address_full', types: ['purchase_order', 'purchase_order_updated', 'bulk_purchase_order', 'user_purchase_order'] },
      { name: 'Supplier Address Name', variable: 'supplier_address_name', types: ['purchase_order', 'purchase_order_updated', 'bulk_purchase_order', 'user_purchase_order'] },
      { name: 'Supplier Address Line 1', variable: 'supplier_address_address1', types: ['purchase_order', 'purchase_order_updated', 'bulk_purchase_order', 'user_purchase_order'] },
      { name: 'Supplier Address Line 2', variable: 'supplier_address_address2', types: ['purchase_order', 'purchase_order_updated', 'bulk_purchase_order', 'user_purchase_order'] },
      { name: 'Supplier Address Line 3', variable: 'supplier_address_address3', types: ['purchase_order', 'purchase_order_updated', 'bulk_purchase_order', 'user_purchase_order'] },
      { name: 'Supplier Address City', variable: 'supplier_address_city', types: ['purchase_order', 'purchase_order_updated', 'bulk_purchase_order', 'user_purchase_order'] },
      { name: 'Supplier Address Province Code', variable: 'supplier_address_province_code', types: ['purchase_order', 'purchase_order_updated', 'bulk_purchase_order', 'user_purchase_order'] },
      { name: 'Supplier Address Zip/Postal Code', variable: 'supplier_address_postal_code', types: ['purchase_order', 'purchase_order_updated', 'bulk_purchase_order', 'user_purchase_order'] },
      { name: 'Supplier Address Country', variable: 'supplier_address_country', types: ['purchase_order', 'purchase_order_updated', 'bulk_purchase_order'] },

      { name: 'Destination Name', variable: 'destination_name', types: ['purchase_order', 'purchase_order_updated', 'user_purchase_order'] },

      // Destination Address
      { name: 'Destination Address', variable: 'destination_address_full', types: ['purchase_order', 'purchase_order_updated', 'user_purchase_order'] },
      { name: 'Destination Address Name', variable: 'destination_address_name', types: ['purchase_order', 'purchase_order_updated', 'user_purchase_order'] },
      { name: 'Destination Address Line 1', variable: 'destination_address_address1', types: ['purchase_order', 'purchase_order_updated', 'user_purchase_order'] },
      { name: 'Destination Address Line 2', variable: 'destination_address_address2', types: ['purchase_order', 'purchase_order_updated', 'user_purchase_order'] },
      { name: 'Destination Address Line 3', variable: 'destination_address_address3', types: ['purchase_order', 'purchase_order_updated', 'user_purchase_order'] },
      { name: 'Destination Address City', variable: 'destination_address_city', types: ['purchase_order', 'purchase_order_updated', 'user_purchase_order'] },
      { name: 'Destination Address Province Code', variable: 'destination_address_province_code', types: ['purchase_order', 'purchase_order_updated', 'user_purchase_order'] },
      { name: 'Destination Address Zip/Postal Code', variable: 'destination_address_postal_code', types: ['purchase_order', 'purchase_order_updated', 'user_purchase_order'] },
      { name: 'Destination Address Country', variable: 'destination_address_country', types: ['purchase_order', 'purchase_order_updated', 'user_purchase_order'] },

      { name: 'Purchase Order Date', variable: 'purchase_order_date', types: ['purchase_order', 'purchase_order_updated', 'user_purchase_order'], isDate: true },
      { name: 'Company Name', variable: 'company_name', types: ['purchase_order', 'purchase_order_updated', 'bulk_purchase_order', 'user_purchase_order'] },
      { name: 'Company Contact', variable: 'company_contact_name', types: ['purchase_order', 'purchase_order_updated', 'bulk_purchase_order', 'user_purchase_order'] },
      { name: 'Company Email', variable: 'company_email', types: ['purchase_order', 'purchase_order_updated', 'bulk_purchase_order', 'user_purchase_order'] },
      { name: 'Order Item List', variable: 'purchase_order_lines', types: ['purchase_order', 'purchase_order_updated', 'user_purchase_order'] },
      { name: 'Total Units Requested', variable: 'product_units', types: ['purchase_order', 'purchase_order_updated', 'user_purchase_order'] },
      { name: 'Purchase Order Total', variable: 'product_total', types: ['purchase_order', 'purchase_order_updated', 'user_purchase_order'] },
      { name: 'Supplier Notes', variable: 'supplier_notes', types: ['purchase_order', 'purchase_order_updated', 'user_purchase_order'] },
      { name: 'ETA', variable: 'estimated_delivery_date', types: ['purchase_order', 'purchase_order_updated', 'user_purchase_order'] },

      { name: 'PO Number List', variable: 'po_number_list', types: ['bulk_purchase_order'] },

      { name: 'Latest Covered Ship by Date', variable: 'latest_covered_ship_by_date', types: ['user_sales_order'] }
    ]
  },
  getters: {
    getDrawers: state => [
      { type: 'sales_order_confirmation', name: 'Sales Order Confirmation' },
      { type: 'sales_order_fulfilled', name: 'Sales Order Fulfilled' },
      { type: 'sales_credit_issued', name: 'Sales Credit' },
      { type: 'purchase_order', name: 'Purchase Order' },
      { type: 'purchase_order_updated', name: 'Purchase Order Update' },
      { type: 'bulk_purchase_order', name: 'Purchase Order (Batch)' }
    ],

    getSelectedItem: state => state.selectedItem,

    getSomethingChanged: (state, getters) => {
      if (!state.editedItem || !state.selectedItem) return false
      return state.editedItem.subject !== state.selectedItem.subject ||
        state.editedItem.html_body !== state.selectedItem.html_body ||
        state.editedItem.type !== state.selectedItem.type ||
        state.editedItem.cc?.join(',') !== state.selectedItem.cc?.join(',') ||
        !!state.editedItem.enabled !== !!state.selectedItem.enabled
    },

    getEmailTemplateDrawer: state => state.emailTemplateDrawer,
    getBlurData: state => state.blurData,
    getViewingHTML: state => state.viewingHTML,
    getEditedItem: state => state.editedItem,

    getVariables: state => state.variables,
    getDrawerMode: state => state.drawerMode,
    getWasSubjectLastFocused: state => state.wasSubjectLastFocused,

    getTypeVariables: (state, getters) => {
      let variables = []
      if (getters.getDrawerMode) {
        variables = getters.getVariables.filter(i => {
          return i.types.includes(getters.getDrawerMode)
        })
      }
      return variables
    },
    getTemplates: state => state.templates,
  },
  mutations: {
    SET_SELECTED_ITEM (state, value) {
      state.selectedItem = value
    },
    SET_DRAWER_MODE (state, value) {
      state.drawerMode = value
    },

    SET_EMAIL_TEMPLATE_DRAWER_FIELD (state, { field, value }) {
      Vue.prototype.$set(state.emailTemplateDrawer, field, value)
    },

    SET_BLUR_DATA (state, value) {
      state.blurData = value
    },

    SET_VIEWING_HTML (state, value) {
      state.viewingHTML = value
    },

    SET_EDITED_ITEM (state, value) {
      state.editedItem = JSON.parse(JSON.stringify(value))
    },
    SET_WAS_SUBJECT_LAST_FOCUSED (state, value) {
      state.wasSubjectLastFocused = value
    },
    SET_EDITED_ITEM_FIELD (state, { field, value }) {
      Vue.prototype.$set(state.editedItem, field, value)
    },
    SET_TEMPLATES (state, value) {
      state.templates = value
    }
  },
  actions: {
    async getTemplates ({ commit }) {
      const response = await getUserTemplates()
      commit('SET_TEMPLATES', response.data)
    }
  }
}
