import { getFinancialsSummaryByPeriod } from '@/services/FinancialsService'

const METRIC = {
  REVENUE: 'revenue',
  PROFIT: 'profit'
}

export const DashboardModule = {
  namespaced: true,
  state: {
    selectedMetric: METRIC.REVENUE,
    startDate: null,
    endDate: null,
    ordersReport: [],
    ordersReportLoading: false,
    ordersReportForSummaries: [], // last 6 months
    ordersReportForSummariesLoading: false,
  },
  getters: {
    getSelectedMetric: state => state.selectedMetric,
    getStartDate: state => state.startDate,
    getEndDate: state => state.endDate,
    getOrdersReport: state => state.ordersReport,
    getOrdersReportForSummaries: state => state.ordersReportForSummaries,
    getOrdersReportLoading: state => state.ordersReportLoading,
    getMetricProfit: () => METRIC.PROFIT,
    getMetricRevenue: () => METRIC.REVENUE,
    isRevenue: (_,getters) => METRIC.REVENUE === getters.getSelectedMetric,
    getOrdersReportForSummariesLoading: state => state.ordersReportForSummariesLoading,
  },
  mutations: {
    SET_START_DATE (state, value) {
      state.startDate = value
    },
    SET_END_DATE (state, value) {
      state.endDate = value
    },
    SET_SELECTED_METRIC (state, value) {
      state.selectedMetric = value
    },
    SET_ORDERS_REPORT (state, value) {
      state.ordersReport = value
    },
    SET_ORDERS_REPORT_LOADING (state, value) {
      state.ordersReportLoading = value
    },
    SET_ORDERS_REPORT_FOR_SUMMARIES (state, value) {
      state.ordersReportForSummaries = value
    },
    SET_ORDERS_REPORT_FOR_SUMMARIES_LOADING (state, value) {
      state.ordersReportForSummariesLoading = value
    },
  },
  actions: {
    /**
     * Loads reporting data for orders
     */
    async loadOrdersReport ({ commit, state }, {startDate = null, endDate = null} = {}) {
      commit('SET_ORDERS_REPORT_LOADING', true)
      const start = startDate ?? state.startDate.format('YYYY-MM-DD')
      const end = endDate ?? state.endDate.format('YYYY-MM-DD')
      try {
        const {data} = await getFinancialsSummaryByPeriod({
          period: 'day',
          'filter[end_date]': end,
          'filter[start_date]': start,
        })

        commit('SET_ORDERS_REPORT', data)
      } catch (e) {
        return Promise.reject(e)
      } finally {
        commit('SET_ORDERS_REPORT_LOADING', false)
      }
    }
  }
}
