import { getCurrencies } from '@/services/CurrenciesService'

export const CurrenciesModule = {
  namespaced: true,
  state: {
    currencies: [],
    defaultCurrency: null,
    currenciesLoading: false
  },
  getters: {
    getCurrenciesList: state => state.currencies,
    getDefaultCurrency: (state, getters) => {
      if (state.defaultCurrency) return state.defaultCurrency
      return getters.getCurrenciesList.find(i => i.is_default === true)
    },
    getCurrenciesLoading: state => state.currenciesLoading

  },
  mutations: {
    SET_CURRENCIES (state, value) {
      if (value) {
        value.map(i => {
          i.fullName = `${i.name} (${i.code})`
          return i
        })
      }
      state.currencies = value
    },
    SET_CURRENCIES_LOADING (state, value) {
      state.currenciesLoading = value
    },
    SET_DEFAULT_CURRENCY (state, value) {
      state.defaultCurrency = value
    }
  },
  actions: {
    async getCurrenciesRequest ({ commit }) {
      try {
        commit('SET_CURRENCIES_LOADING', true)
        const response = await getCurrencies()
        if (response) {
          commit('SET_CURRENCIES', response)
        }
      } catch (e) {
        throw e
      } finally {
        commit('SET_CURRENCIES_LOADING', false)
      }
    }
  }
}
