import { getCountries, getCountriesGrouped, getAllCurrencies, getStates } from '@/services/ConstantsService'

export const ConstantsModule = {
  namespaced: true,
  state: {
    countries: [],
    countriesGrouped: [],
    currencies: [],
    states: [],
    currenciesLoading: false,
  },
  getters: {
    getCountries: (state) => {
      let countries
      if (sessionStorage.getItem('SKUCountries')) {
        countries = JSON.parse(sessionStorage.getItem('SKUCountries'))
      } else {
        countries = state.countries
      }

      return countries.sort((a, b) => {
        if (a.name === 'United States') return -1
        if (a.name === 'Canada') return -1
        return 1
      })
    },
    getCountriesGrouped: (state) => {
      if (sessionStorage.getItem('SKUCountriesGrouped')) {
        return JSON.parse(sessionStorage.getItem('SKUCountriesGrouped'))
      }
      return state.countriesGrouped
    },
    getStates: state => state.states,
    getCurrencies: (state) => {
      let currencies
      if (sessionStorage.getItem('SKUCurrencies')) {
        currencies = JSON.parse(sessionStorage.getItem('SKUCurrencies'))
      } else {
        currencies = state.currencies
      }

      return currencies.sort((a, b) => {
        if (a.name === 'US Dollar') return -1
        if (a.name === 'Canadian Dollar') return -1
        return 1
      })
    },
    getCurrenciesLoading: state => state.currenciesLoading
  },
  mutations: {
    SET_COUNTRIES (state, value) {
      state.countries = value
    },
    SET_COUNTRIES_GROUPED (state, value) {
      state.countriesGrouped = value
    },
    SET_CURRENCIES (state, value) {
      if (value) {
        value.map(i => {
          i.fullName = `${i.name} (${i.code})`
          return i
        })
      }
      state.currencies = value
    },
    SET_CURRENCIES_LOADING (state, value) {
      state.currenciesLoading = value
    },
    SET_STATES (state, value) {
      state.states = value
    }
  },
  actions: {
    async getCountriesRequest ({ commit }, query = {limit:-1}) {
      try {
        const response = await getCountries(query)
        if (response) {
          commit('SET_COUNTRIES', response.data)
          sessionStorage.setItem('SKUCountries', JSON.stringify(response.data))
        }
      } catch (e) {
        throw e
      }
    },
    async getCountriesGroupedRequest ({ commit }) {
      try {
        const response = await getCountriesGrouped()

        if (response) {
          commit('SET_COUNTRIES_GROUPED', response.data)
          sessionStorage.setItem('SKUCountriesGrouped', JSON.stringify(response.data))
        }
      } catch (e) {
        throw e
      }
    },
    async getStatesRequest ({ commit }, countryCode) {
      try {
        const response = await getStates(countryCode)
        if (response) {
          commit('SET_STATES', response.data)
        }
      } catch (e) {
        throw e
      }
    },
    async getCurrenciesRequest ({ commit }, query) {
      try {
        commit('SET_CURRENCIES_LOADING', true)
        const response = await getAllCurrencies(query)
        if (response) {
          commit('SET_CURRENCIES', response.data)
          sessionStorage.setItem('SKUCurrencies', JSON.stringify(response.data))
        }
      } catch (e) {
        throw e
      } finally {
        commit('SET_CURRENCIES_LOADING', false)
      }
    },
    async fetchCountriesOnce ({ dispatch, getters }, query = {limit:-1}) {
      if (getters.getCountries.length) return

      dispatch('getCountriesRequest', query)
    },
    async fetchCurrenciesOnce ({ dispatch, getters }, query) {
      if (getters.getCurrencies.length) return

      dispatch('getCurrenciesRequest', query)
    }
  }
}
