import { getAllShippingCarriers } from '@/services/orders/ShippingCarriersService'

export const CarriersModule = {
  namespaced: true,
  state: {
    carriers: [],
    carriersLoading: false,
    selectedCarrier: null
  },
  getters: {
    getCarriers: state => state.carriers,
    getCarriersLoading: state => state.carriersLoading,
    getSelectedCarrier: state => state.selectedCarrier,
    getShippingMethods: (state, getters) => {
      let methodsArray = []
      getters.getCarriers.forEach((carrier, index) => {
        carrier.shipping_methods.forEach(method => {
          methodsArray.push({
            ...method,
            id: method.id,
            name: method.name,
            fullName: `${carrier.name} | ${method.name}`
          })
        })
      })
      return methodsArray
    }
  },
  mutations: {
    SET_CARRIERS (state, value) {
      state.carriers = value
    },
    SET_CARRIERS_LOADING (state, value) {
      state.carriersLoading = value
    },
    SET_SELECTED_CARRIER (state, value) {
      state.selectedCarrier = value
    }
  },
  actions: {
    async fetchAllCarriers ({ commit }) {
      try {
        commit('SET_CARRIERS_LOADING', true)
        const response = await getAllShippingCarriers()
        commit('SET_CARRIERS', response.data)
      } catch (e) {
        throw e
      } finally {
        commit('SET_CARRIERS_LOADING', false)
      }
    }
  }
}
