import { getBackorderQueues } from '@/services/BackorderQueueService'

export const BackorderQueueModule = {
  namespaced: true,
  state: {
    itemsList: [],
    tableSpecifications: {},
    maxPages: 0,
    meta: {},
    loading: false
  },
  getters: {
    getItemsList: state => state.itemsList,
    getTableSpecifications: state => state.tableSpecifications,
    getMaxPages: state => state.maxPages,
    getMeta: state => state.meta,
    getLoading: state => state.loading
  },
  mutations: {
    SET_ITEMS_LIST (state, value) {
      state.itemsList = value
    },
    SET_TABLE_SPECIFICATIONS (state, value) {
      state.tableSpecifications = value
    },
    SET_MAX_PAGES (state, value) {
      state.maxPages = value
    },
    SET_META (state, value) {
      state.meta = value
    },
    SET_LOADING (state, value) {
      state.loading = value
    }
  },
  actions: {
    async getItemsRequest ({ commit }, query) {
      try {
        commit('SET_LOADING', true)
        const response = await getBackorderQueues(query)
        commit('SET_ITEMS_LIST', response.data)
        if (response.table_specifications) commit('SET_TABLE_SPECIFICATIONS', response.table_specifications)
      } catch (e) {
        throw e
      } finally {
        commit('SET_LOADING', false)
      }
    },
    async getMetaRequest ({ commit }, query) {
      try {
        const response = await getBackorderQueues(query)
        if (response.meta && response.meta.last_page) commit('SET_MAX_PAGES', response.meta.last_page)
        if (response.meta) commit('SET_META', response.meta)
      } catch (e) {
        throw e
      }
    },
    async loadTableSpecifications ({ commit }, query) {
      try {
        const response = await getBackorderQueues(query)

        if (response.data?.table_specifications) commit('SET_TABLE_SPECIFICATIONS', response.data.table_specifications)
        return Promise.resolve()
      } catch (e) {
        throw e
      }
    },
  }
}
