import { getAccountingIntegration } from '@/services/AccountingService'

export const AccountingModule = {
  namespaced: true,
  state: {
    integration: null,
    loadingIntegration: false,
    accountingMenuItems: [
      { name: 'Settings', label: '', url: '/settings/accounting-general' },
      { name: 'Payments', label: '', url: '/accounting/payments' },
      { name: 'Transactions', label: '', url: '/accounting/transactions' },
    ]
  },
  getters: {
    getAccountingIntegration: state => state.integration,
    getIntegrationLoading: state => state.loadingIntegration,
    getIntegrationUrl: (state) => {
      if (!state.integration || !state.integration.id || !state.integration.name) return '/'
      return `/integrations/${state.integration.name.toLowerCase()}/${state.integration.id}/dashboard`
    },
    getAccountingMenuItems: (state, getters) => {
      if (getters.getAccountingIntegration && !getters.checkIsExistMenuItem(getters.getAccountingIntegrationMenuItem)) {
        state.accountingMenuItems.push(getters.getAccountingIntegrationMenuItem)
      }
      return state.accountingMenuItems
    },
    checkIsExistMenuItem: state => ({url, name}) => {
      return !!state.accountingMenuItems
        .filter(item => item.url === url && item.name === name)
        .length > 0
    },
    getAccountingIntegrationMenuItem: (_, getters) => {
      return { 
        name: getters.getAccountingIntegration?.name,
        label: '',
        url: getters.getIntegrationUrl
      }
    }
  },
  mutations: {
    SET_ACCOUNTING_INTEGRATION (state, value) {
      state.integration = value
    },
    SET_LOADING_INTEGRATION (state, value = false) {
      state.loadingIntegration = value
    }
  },
  actions: {
    async fetchAccountingIntegration ({commit}) {
      commit('SET_LOADING_INTEGRATION', true)
      try {
        const data = await getAccountingIntegration()
        if (data) commit('SET_ACCOUNTING_INTEGRATION', data)
      } catch (e) {
        throw e
      } finally {
        commit('SET_LOADING_INTEGRATION')
      }
    }
  }
}
