import {postAxiosRequest, getAxiosRequest, putAxiosRequest} from '@/support/apiRequestHelpers'
import buildUrlParams from '@/support/buildUrlParams'

const getUrl = (instanceId, path = '') => {
  const baseUrl = `/woo-commerce/${instanceId}/products`
  return path ? `${baseUrl}/${path}` : baseUrl
}

export const fetchWoocommerceProductById = (instanceId, productId) => getAxiosRequest(getUrl(`${instanceId}`,productId))

export const fetchWoocommerceProducts = (instanceId, params) => getAxiosRequest(getUrl(`${instanceId}`), buildUrlParams(params))

export const refreshWoocommerceProducts = (instanceId) => postAxiosRequest(getUrl(`${instanceId}`,`refresh`))

export const createWoocommerceSkuProducts = (instanceId, sendData, filters = null) => {
  let params = {}
  if (filters && filters.conjunction) params.filters = JSON.stringify(filters)
  return postAxiosRequest(getUrl(instanceId,`create-sku-products`), sendData, {params})
}

export const mapProductWoocommerceIntegrationInstance = (id, sendData) => putAxiosRequest(getUrl(id ,'map'), sendData)
