import {postAxiosRequest, getAxiosRequest} from '@/support/apiRequestHelpers'
import buildUrlParams from '@/support/buildUrlParams'

const getUrl = (instanceId, path = '') => {
  const baseUrl = `/woo-commerce/${instanceId}/orders`
  return path ? `${baseUrl}/${path}` : baseUrl
}

export const fetchWoocommerceOrders = (instanceId, params) => getAxiosRequest(getUrl(instanceId), buildUrlParams(params))

export const refreshWooCommerceOrders = (instanceId) => postAxiosRequest(getUrl(instanceId,'refresh'))

export const fetchWoocommerceOrderById = (instanceId,id) => getAxiosRequest(getUrl(instanceId,id))

export const createWoocommerceSkuOrder = (instanceId,sendData) => postAxiosRequest(getUrl(instanceId,'create-sku-orders'), sendData)
