import { getAxiosRequest, postAxiosRequest } from '@/support/apiRequestHelpers'
import axiosConfig from '@/config/axiosConfig'

const baseURL = '/shipstation/warehouses'
const getUrl = (path = '') => (path ? `${baseURL}/${path}` : baseURL)

export const fetchShipstationWarehouses = () => getAxiosRequest(getUrl())

export const fetchWarehouseMappings = () => getAxiosRequest(getUrl('mappings'))

export const downloadWarehouses = () => postAxiosRequest(getUrl('download'))

export const mapShipstationWarehouse = async (sendData) => {
  try {
    const { data } = await axiosConfig.post(`${baseURL}/map`, sendData)
    return data
  } catch (e) {
    console.log(e)
    return Promise.reject(e)
  }
}

export const deleteShipstationWarehouseMapping = async (sendData) => {
  try {
    const { data } = await axiosConfig.post(`${baseURL}/unmap`, sendData)
    return data
  } catch (e) {
    console.log(e)
    return Promise.reject(e)
  }
}
