import { postAxiosRequest, getAxiosRequest } from '@/support/apiRequestHelpers'

const getUrl = (path = '') => {
  const baseUrl = `/shipmyorders/inventory`
  return path ? `${baseUrl}/${path}` : baseUrl
}

export const fetchSmoInventoryDiscrepancies = () => getAxiosRequest(getUrl('discrepancies'))
export const fetchSmoInventoryWithoutSkuProducts = () => getAxiosRequest(getUrl('without-sku-products'))
export const fetchSmoInventoryWithoutSmoInventory = () => getAxiosRequest(getUrl('without-smo-inventory'))

export const refreshSmoInventory = () => postAxiosRequest(getUrl('refresh'))
