import axiosConfig from '../../config/axiosConfig'

const baseURL = '/shipping-providers'

// Get All Shipping Providers
export const getAllShippingProviders = async () => {
  try {
    const { data } = await axiosConfig.get(baseURL)
    return data
  } catch (e) {
    return Promise.reject(e)
  }
}

// Get Shipping Provider By ID
export const getShippingProviderByID = async (shippingProviderID) => {
  const url = `${baseURL}/${shippingProviderID}`

  try {
    const { data } = await axiosConfig.get(url)
    return data
  } catch (e) {
    return Promise.reject(e)
  }
}

// Create Shipping Provider
export const createShippingProvider = async (shippingProviderData) => {
  try {
    const { data } = await axiosConfig.post(baseURL, { ...shippingProviderData })
    return data
  } catch (e) {
    return Promise.reject(e)
  }
}

// Update Shipping Provider
export const updateShippingProvider = async (shippingProviderID, shippingProviderData) => {
  const url = `${baseURL}/${shippingProviderID}`

  try {
    const { data } = await axiosConfig.put(url, { ...shippingProviderData })
    return data
  } catch (e) {
    return Promise.reject(e)
  }
}
