import axiosConfig from '../../config/axiosConfig'

const baseURL = '/shipping-carriers'

// Get All Shipping Carriers
export const getAllShippingCarriers = async () => {
  try {
    const { data } = await axiosConfig.get(baseURL)
    return data
  } catch (e) {
    return Promise.reject(e)
  }
}

// Get Shipping Carrier By ID
export const getShippingCarrierByID = async (shippingCarrierID) => {
  const url = `${baseURL}/${shippingCarrierID}`

  try {
    const { data } = await axiosConfig.get(url)
    return data
  } catch (e) {
    return Promise.reject(e)
  }
}

// Create Shipping Carrier
export const createShippingCarrier = async (shippingCarrierData) => {
  try {
    const { data } = await axiosConfig.post(baseURL, { ...shippingCarrierData })
    return data
  } catch (e) {
    return Promise.reject(e)
  }
}

// Update Shipping Carrier
export const updateShippingCarrier = async (shippingCarrierID, shippingCarrierData) => {
  const url = `${baseURL}/${shippingCarrierID}`

  try {
    const { data } = await axiosConfig.put(url, { ...shippingCarrierData })
    return data
  } catch (e) {
    return Promise.reject(e)
  }
}
