import {postAxiosRequest, putAxiosRequest, deleteAxiosRequest, getAxiosRequest} from '@/support/apiRequestHelpers'

const getUrl = (path = '') => {
  const baseURL = '/sales-order-lines'
  return path ? `${baseURL}/${path}` : `${baseURL}`
}

export const deleteSalesOrderLine = async (orderLineID) => await deleteAxiosRequest(getUrl(orderLineID))

export const translateCsvListForSalesOrders = async (sendData) => await postAxiosRequest(`import`, sendData)

export const mapSalesOrdersLine = async (lineId, sendData) => await putAxiosRequest(getUrl(`${lineId}/map`), sendData)

export const reservationSalesOrdersLine = async (sendData) => await postAxiosRequest(getUrl('reservations'), sendData)

export const fetchSalesOrderLineDetail = async (lineId) => await getAxiosRequest(getUrl(`${lineId}`), [])

export const convertSOLineToFinancialLine = async (lineId, financialLineTypeId) => await postAxiosRequest(getUrl(`${lineId}/${financialLineTypeId}/convert-to-financial-line`))
