import axiosConfig from '@/config/axiosConfig'
import buildUrlParams from '@/support/buildUrlParams'

const baseURL = '/sales-credits'

export const fetchSalesCredits = async (options = {}) => {
  try {
    const { data } = await axiosConfig.get(baseURL, buildUrlParams(options))
    return data
  } catch (e) {
    return Promise.reject(e)
  }
}

export const getSalesCreditByID = async (id) => {
  const url = `${baseURL}/${id}`

  try {
    const { data } = await axiosConfig.get(url)
    return data.data
  } catch (e) {
    return Promise.reject(e)
  }
}

export const createSalesCredit = async (sendData) => {
  try {
    const { data } = await axiosConfig.post(baseURL, sendData)
    return data
  } catch (e) {
    return Promise.reject(e)
  }
}

export const updateSalesCredit = async (id, sendData) => {
  const url = `${baseURL}/${id}`
  try {
    const { data } = await axiosConfig.put(url, sendData)
    return data
  } catch (e) {
    return Promise.reject(e)
  }
}

export const receiveSalesCredit = async (sendData) => {
  const url = `${baseURL}/receive`
  try {
    const { data } = await axiosConfig.post(url, sendData)
    return data
  } catch (e) {
    return Promise.reject(e)
  }
}

export const addPayment = async (creditId, payload) => {
  const url = `${baseURL}/paid`
  payload.sales_credit_id = creditId
  try {
    const { data } = await axiosConfig.post(url, payload)
    return data
  } catch (e) {
    return Promise.reject(e)
  }
}

export const updatePayment = async (creditId, paymentId, payload) => {
  try {
    const { data } = await axiosConfig.put(`${baseURL}/${creditId}/payments/${paymentId}`, payload)
    return data
  } catch (e) {
    return Promise.reject(e)
  }
}

export const deletePayment = async (creditId, paymentId) => {
  const url = `${baseURL}/${creditId}/payments/${paymentId}`
  try {
    const { data } = await axiosConfig.delete(url)
    return data
  } catch (e) {
    return Promise.reject(e)
  }
}

export const archiveSalesCreditByID = async (id) => {
  const url = `${baseURL}/${id}/archive`

  try {
    const { data } = await axiosConfig.put(url)
    return data
  } catch (e) {
    return Promise.reject(e)
  }
}

export const unarchiveSalesCreditByID = async (id) => {
  const url = `${baseURL}/${id}/unarchived`

  try {
    const { data } = await axiosConfig.put(url)
    return data
  } catch (e) {
    return Promise.reject(e)
  }
}

export const archiveSalesCredits = async (sendData) => {
  const url = `${baseURL}/archive`

  try {
    const { data } = await axiosConfig.put(url, sendData)
    return data
  } catch (e) {
    return Promise.reject(e)
  }
}

export const unarchiveSalesCredits = async (sendData) => {
  const url = `${baseURL}/unarchive`

  try {
    const { data } = await axiosConfig.put(url, sendData)
    return data
  } catch (e) {
    return Promise.reject(e)
  }
}

export const deleteSalesCreditByID = async (id) => {
  const url = `${baseURL}/${id}`

  try {
    const { data } = await axiosConfig.delete(url)
    return data
  } catch (e) {
    return Promise.reject(e)
  }
}

// Delete  By IDs
export const deleteSalesCredits = async (sendData) => {
  try {
    const { data } = await axiosConfig.delete(baseURL, { params: sendData })
    return data
  } catch (e) {
    return Promise.reject(e)
  }
}

export const deleteSalesCreditReturnLine = async (id) => {
  const url = `${baseURL}/return-lines/${id}`
  try {
    const { data } = await axiosConfig.delete(url)
    return data
  } catch (e) {
    return Promise.reject(e)
  }
}

export const getCreditNotes = async (creditId) => {
  try {
    const { data } = await axiosConfig.get(`${baseURL}/${creditId}/notes`)
    return data
  } catch (e) {
    return Promise.reject(e)
  }
}

export const addCreditNote = async (creditId, payload) => {
  try {
    const { data } = await axiosConfig.post(`${baseURL}/${creditId}/notes`, { ...payload })
    return data
  } catch (e) {
    return Promise.reject(e)
  }
}

export const deleteCreditNote = async (creditId, noteId) => {
  try {
    const { data } = await axiosConfig.delete(`${baseURL}/${creditId}/notes/${noteId}`)
    return data
  } catch (e) {
    return Promise.reject(e)
  }
}

// check sales credits deleatbility
export const isDeletable = async (ids) => {
  try {
    const { data } = await axiosConfig.post(`${baseURL}/deletable`, { ids })
    return data
  } catch (e) {
    return Promise.reject(e)
  }
}
