import axiosConfig from '@/config/axiosConfig'
import { getAxiosRequest, postAxiosRequest, putAxiosRequest, deleteAxiosRequest } from '@/support/apiRequestHelpers'

const baseURL = 'purchase-invoices'

export const createPurchaseInvoice = async (sendData) => {
  try {
    const { data } = await axiosConfig.post(baseURL, sendData)
    return data
  } catch (e) {
    return Promise.reject(e)
  }
}

export const editPurchaseInvoice = async (id, sendData) => {
  const url = `${baseURL}/${id}`
  try {
    const { data } = await axiosConfig.put(url, sendData)
    return data
  } catch (e) {
    return Promise.reject(e)
  }
}

export const getPurchaseInvoices = async (id) => {
  const url = `purchase-orders/${id}/invoices`
  try {
    const { data } = await axiosConfig.get(url)
    return data
  } catch (e) {
    return Promise.reject(e)
  }
}

export const deletePurchaseInvoice = async (id) => {
  const url = `${baseURL}/${id}`
  try {
    const { data } = await axiosConfig.delete(url)
    return data
  } catch (e) {
    return Promise.reject(e)
  }
}

export const isDeletablePurchaseInvoice = async (ids) => {
  const url = `${baseURL}/deletable`
  try {
    const { data } = await axiosConfig.post(url, { ids })
    return data
  } catch (e) {
    return Promise.reject(e)
  }
}

export const fetchPurchaseInvoicePayment = async (invoiceId, sendData) => {
  return await getAxiosRequest(`${baseURL}/${invoiceId}/payments`, sendData)
}

export const createPurchaseInvoicePayment = async (invoiceId, sendData) => {
  return await postAxiosRequest(`${baseURL}/${invoiceId}/payments`, sendData)
}

export const updatePurchaseInvoicePayment = async (invoiceId, paymentId, sendData) => {
  return await putAxiosRequest(`${baseURL}/${invoiceId}/payments/${paymentId}`, sendData)
}

export const deletePurchaseInvoicePayment = async (invoiceId, paymentId) => {
  return await deleteAxiosRequest(`${baseURL}/${invoiceId}/payments/${paymentId}`)
}
