import { postAxiosRequest,putAxiosRequest,getAxiosRequest,deleteAxiosRequest } from '@/support/apiRequestHelpers'

const baseURL = '/financial-line-types'

export const createFinancialLineType = async (payloads) => await postAxiosRequest(baseURL, payloads)

export const updateFinancialLineType = async (id, payloads) => await putAxiosRequest(`${baseURL}/${id}`, payloads)

export const deleteFinancialLineType = async (id) => await deleteAxiosRequest(`${baseURL}/${id}`)

export const fetchFinancialLineTypes = async (params) => await getAxiosRequest(baseURL, {params})
