import { postAxiosRequest, getAxiosRequest, putAxiosRequest } from '@/support/apiRequestHelpers'
import buildUrlParams from '@/support/buildUrlParams'

const getUrl = (path = '') => {
  const baseUrl = `/ebay-product-settings`
  return path ? `${baseUrl}/${path}` : baseUrl
}

export const fetchEbayProductSettings = (params) => getAxiosRequest(getUrl('') + params)
export const upsertEbayProductSetting = (sendData) => postAxiosRequest(getUrl(''), sendData)
