import { postAxiosRequest, getAxiosRequest, putAxiosRequest } from '@/support/apiRequestHelpers'
import buildUrlParams from '@/support/buildUrlParams'

const getUrl = (instanceId, path = '') => {
  const baseUrl = `/ebay/${instanceId}/legacy-products`
  return path ? `${baseUrl}/${path}` : baseUrl
}

export const fetchEbayProductById = (instanceId, productId) => getAxiosRequest(getUrl(`${instanceId}`, productId))

export const fetchEbayProducts = (instanceId, params) => getAxiosRequest(getUrl(`${instanceId}`), buildUrlParams(params))

export const refreshEbayProducts = (instanceId) => postAxiosRequest(getUrl(`${instanceId}`, `refresh`))

export const createEbaySkuProducts = (instanceId, sendData, filters = null) => {
  let params = {}
  if (filters && filters.conjunction) params.filters = JSON.stringify(filters)
  return postAxiosRequest(getUrl(instanceId, `create-sku-products`), sendData, { params })
}

export const mapProductEbayIntegrationInstance = (id, sendData) => putAxiosRequest(getUrl(id, 'map'), sendData)

export const hydrateProductTemplate = (instanceId, sendData) => postAxiosRequest(getUrl(`${instanceId}`, 'hydrate-product-template'), sendData)

export const getEbaySuggestedCategories = (instanceId, sendData) => postAxiosRequest(getUrl(`${instanceId}`, 'get-suggested-categories'), sendData)

export const buildEbayPayload = (instanceId, sendData) => postAxiosRequest(getUrl(`${instanceId}`, 'build-payload'), sendData)

export const publishEbayProducts = (instanceId, sendData) => postAxiosRequest(getUrl(`${instanceId}`, 'publish'), sendData)
