import axiosConfig from '../config/axiosConfig'

const baseURL = '/warehouse-locations'

// Create New Warehouse Location
export const createWarehouseLocation = async (warehouseLocationData) => {
  try {
    const { data } = await axiosConfig.post(baseURL, { ...warehouseLocationData })
    return data
  } catch (e) {
    return Promise.reject(e)
  }
}

// Update Warehouse Location
export const updateWarehouseLocation = async (warehouseLocationID, warehouseLocationData) => {
  const url = `${baseURL}/${warehouseLocationID}`

  try {
    const { data } = await axiosConfig.put(url, { ...warehouseLocationData })
    return data
  } catch (e) {
    return Promise.reject(e)
  }
}
