import axiosConfig from '../config/axiosConfig'

const baseURL = '/table-views'

// Get All Table Views
export const getAllTableViews = async ({ model }) => {
  let constructedQuery = ''

  if (model) constructedQuery += `?model=${model}`

  try {
    const { data } = await axiosConfig.get(baseURL + constructedQuery)
    return data.data
  } catch (e) {
    return Promise.reject(e)
  }
}

// Create New Table View
export const createTableView = async (tableViewData) => {
  try {
    const { data } = await axiosConfig.post(baseURL, { ...tableViewData })
    return data
  } catch (e) {
    return Promise.reject(e)
  }
}

// Update Table View
export const updateTableView = async (tableViewID, tableViewData) => {
  const url = `${baseURL}/${tableViewID}`

  try {
    const { data } = await axiosConfig.put(url, { ...tableViewData })
    return data
  } catch (e) {
    return Promise.reject(e)
  }
}

// Delete Table View
export const deleteTableView = async (tableViewID) => {
  const url = `${baseURL}/${tableViewID}`

  try {
    const { data } = await axiosConfig.delete(url)
    return data
  } catch (e) {
    return Promise.reject(e)
  }
}

// Set Default Table View
export const setDefaultTableView = async (tableViewID) => {
  const url = `${baseURL}/set-default-view/${tableViewID}`

  try {
    const { data } = await axiosConfig.put(url)
    return data
  } catch (e) {
    return Promise.reject(e)
  }
}
