import axiosConfig from '../config/axiosConfig'
import buildUrlParams from '@/support/buildUrlParams'

const baseURL = '/supplier-pricing-tiers'

export const getAllSupplierPricingTiers = async (options = {}) => {
  try {
    const { data } = await axiosConfig.get(baseURL, buildUrlParams(options))
    return data
  } catch (e) {
    return Promise.reject(e)
  }
}

// Create Supplier pricing tier
export const createSupplierPricingTier = async (supplierPricingTierData) => {
  try {
    const { data } = await axiosConfig.post(baseURL, { ...supplierPricingTierData })
    return data
  } catch (e) {
    if (e.response) {
      return e.response
    }
  }
}

// Update Supplier pricing tier
export const updateSupplierPricingTier = async (supplierPricingTierID, supplierPricingTierData) => {
  const url = `${baseURL}/${supplierPricingTierID}`

  try {
    const { data } = await axiosConfig.put(url, { ...supplierPricingTierData })
    return data
  } catch (e) {
    return Promise.reject(e)
  }
}

// set is default Supplier Pricing Tier
export const setIsDefaultSupplierPricingTier = async (supplierPricingTierID) => {
  const url = `${baseURL}/${supplierPricingTierID}/default`

  try {
    const { data } = await axiosConfig.put(url)
    return data
  } catch (e) {
    if (e.response) {
      return e.response
    }
  }
}

// Archive Supplier pricing tier By ID
export const archiveSupplierPricingTierByID = async (supplierPricingTierID) => {
  const url = `${baseURL}/${supplierPricingTierID}/archive`

  try {
    const { data } = await axiosConfig.put(url)
    return data
  } catch (e) {
    return Promise.reject(e)
  }
}

// UnArchive Supplier Pricing Tier By ID
export const unarchiveSupplierPricingTierByID = async (supplierPricingTierID) => {
  const url = `${baseURL}/${supplierPricingTierID}/unarchived`

  try {
    const { data } = await axiosConfig.put(url)
    return data
  } catch (e) {
    return Promise.reject(e)
  }
}

// Delete Supplier Pricing Tier By ID
export const deleteSupplierPricingTierByID = async (supplierPricingTierID) => {
  const url = `${baseURL}/${supplierPricingTierID}`

  try {
    const { data } = await axiosConfig.delete(url)
    return data
  } catch (e) {
    return Promise.reject(e)
  }
}

// Archive Supplier Pricing Tier By IDs
export const archiveSupplierPricingTier = async (sendData) => {
  const url = `${baseURL}/archive`

  try {
    const { data } = await axiosConfig.put(url, sendData)
    return data
  } catch (e) {
    return Promise.reject(e)
  }
}

// unArchive Supplier Pricing Tier By IDs
export const unArchiveSupplierPricingTier = async (sendData) => {
  const url = `${baseURL}/unarchive`

  try {
    const { data } = await axiosConfig.put(url, sendData)
    return data
  } catch (e) {
    return Promise.reject(e)
  }
}

// delete Supplier Pricing Tier By IDs
export const deleteSupplierPricingTier = async (sendData) => {
  const url = `${baseURL}`

  try {
    const { data } = await axiosConfig.delete(url, { data: sendData })
    return data
  } catch (e) {
    return Promise.reject(e)
  }
}

// check Supplier Pricing Tier deleatbility
export const isDeletable = async (ids) => {
  try {
    const { data } = await axiosConfig.post(`${baseURL}/deletable`, { ids })
    return data
  } catch (e) {
    return Promise.reject(e)
  }
}

// check Supplier Pricing Tier archivablity
export const isArchivable = async (ids) => {
  try {
    const { data } = await axiosConfig.post(`${baseURL}/archivable`, { ids })
    return data
  } catch (e) {
    return Promise.reject(e)
  }
}

export const previewPricingTiersImport = async (sendData) => {
  const url = `${baseURL}/import/preview`
  try {
    const { data } = await axiosConfig.post(url, sendData)
    return data
  } catch (e) {
    return Promise.reject(e)
  }
}

export const importPricingTiersData = async (sendData) => {
  const url = `${baseURL}/import`
  try {
    const { data } = await axiosConfig.post(url, sendData)
    return data
  } catch (e) {
    return Promise.reject(e)
  }
}
