import { getAxiosRequest, putAxiosRequest, } from '@/support/apiRequestHelpers'

const baseURL = '/settings'

export const getSettings = async () => getAxiosRequest(baseURL)

export const updateSetting = async (keyOrId, payload) => putAxiosRequest(`${baseURL}/${keyOrId}`, payload)
export const updateDateSetting = async (payload) => putAxiosRequest(`${baseURL}/date-setting`, payload)

export const fetchAppSetting = async () => getAxiosRequest('app-settings')
